/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.TreeNodeDao;
import de.terrestris.shoguncore.helper.IdHelper;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.model.security.Permission;
import de.terrestris.shoguncore.model.security.PermissionCollection;
import de.terrestris.shoguncore.model.tree.TreeFolder;
import de.terrestris.shoguncore.model.tree.TreeNode;
import de.terrestris.shoguncore.service.PermissionAwareCrudService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="treeNodeService")
public class TreeNodeService<E extends TreeNode, D extends TreeNodeDao<E>>
extends PermissionAwareCrudService<E, D> {
    public TreeNodeService() {
        this(TreeNode.class);
    }

    protected TreeNodeService(Class<E> entityClass) {
        super(entityClass);
    }

    public E cloneAndPersistTreeNode(E node) throws Exception {
        return this.cloneAndPersistTreeNode(node, true, new ArrayList());
    }

    private E cloneAndPersistTreeNode(E node, boolean root, List<E> nodes) throws Exception {
        if (node == null) {
            throw new Exception("Node to clone must not be null.");
        }
        node = (TreeNode)((TreeNodeDao)this.dao).unproxy(node);
        HashMap<User, PermissionCollection> userPermissions = new HashMap<User, PermissionCollection>();
        ((PersistentObject)node).getUserPermissions().forEach((user, coll) -> {
            PermissionCollection collection = new PermissionCollection();
            collection.setPermissions(new HashSet<Permission>(coll.getPermissions()));
            userPermissions.put((User)user, collection);
        });
        ((PersistentObject)node).setUserPermissions(userPermissions);
        HashMap<UserGroup, PermissionCollection> groupPermissions = new HashMap<UserGroup, PermissionCollection>();
        ((PersistentObject)node).getGroupPermissions().forEach((group, coll) -> {
            PermissionCollection collection = new PermissionCollection();
            collection.setPermissions(new HashSet<Permission>(coll.getPermissions()));
            groupPermissions.put((UserGroup)group, collection);
        });
        ((PersistentObject)node).setGroupPermissions(groupPermissions);
        if (node instanceof TreeFolder) {
            List<TreeNode> children = ((TreeFolder)node).getChildren();
            ArrayList<TreeNode> clonedChildren = new ArrayList<TreeNode>();
            for (TreeNode childNode : children) {
                TreeNode child = this.cloneAndPersistTreeNode(childNode, false, nodes);
                child.setParentFolder((TreeFolder)node);
                clonedChildren.add(child);
            }
            ((TreeFolder)node).setChildren(clonedChildren);
        }
        ((TreeNodeDao)this.dao).evict(node);
        IdHelper.setIdOnPersistentObject((PersistentObject)node, null);
        nodes.add(node);
        if (root) {
            Collections.reverse(nodes);
            nodes.forEach(((TreeNodeDao)this.dao)::saveOrUpdate);
        }
        return (E)node;
    }

    @Override
    @Autowired
    @Qualifier(value="treeNodeDao")
    public void setDao(D dao) {
        this.dao = dao;
    }
}

