/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.RegistrationTokenDao;
import de.terrestris.shoguncore.dao.RoleDao;
import de.terrestris.shoguncore.dao.UserDao;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.Person;
import de.terrestris.shoguncore.model.Role;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.model.token.RegistrationToken;
import de.terrestris.shoguncore.service.PersonService;
import de.terrestris.shoguncore.service.RegistrationTokenService;
import de.terrestris.shoguncore.service.RoleService;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userService")
public class UserService<E extends User, D extends UserDao<E>>
extends PersonService<E, D> {
    @Autowired
    protected RegistrationTokenService<RegistrationToken, RegistrationTokenDao<RegistrationToken>> registrationTokenService;
    @Autowired
    protected RoleService<Role, RoleDao<Role>> roleService;
    @Autowired
    protected PasswordEncoder passwordEncoder;
    @Autowired(required=false)
    @Qualifier(value="userRole")
    private Role defaultUserRole;

    public UserService() {
        this(User.class);
    }

    protected UserService(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="userDao")
    public void setDao(D dao) {
        super.setDao(dao);
    }

    @PostAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#accountName, 'READ')")
    @Transactional(readOnly=true)
    public E findByAccountName(String accountName) {
        return ((UserDao)this.dao).findByAccountName(accountName);
    }

    @PostAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#email, 'READ')")
    @Transactional(readOnly=true)
    public E findByEmail(String email) {
        return ((UserDao)this.dao).findByEmail(email);
    }

    public E registerUser(E user, HttpServletRequest request) throws Exception {
        String email = ((Person)user).getEmail();
        Object existingUser = ((UserDao)this.dao).findByEmail(email);
        if (existingUser != null) {
            String errorMessage = "User with eMail '" + email + "' already exists.";
            logger.info(errorMessage);
            throw new Exception(errorMessage);
        }
        user = this.persistNewUser(user, true);
        this.registrationTokenService.sendRegistrationActivationMail(request, (User)user);
        return user;
    }

    public void activateUser(String tokenValue) throws Exception {
        String defaultRoleName;
        Role persistedDefaultUserRole;
        RegistrationToken token = (RegistrationToken)this.registrationTokenService.findByTokenValue(tokenValue);
        logger.debug("Trying to activate user account with token: " + tokenValue);
        this.registrationTokenService.validateToken(token);
        User user = token.getUser();
        user.setActive(true);
        if (this.defaultUserRole != null && (persistedDefaultUserRole = this.roleService.findByRoleName(defaultRoleName = this.defaultUserRole.getName())) != null) {
            user.getRoles().add(persistedDefaultUserRole);
        }
        ((UserDao)this.dao).saveOrUpdate(user);
        this.registrationTokenService.deleteTokenAfterActivation(token);
        logger.info("The user '" + user.getAccountName() + "' has successfully been activated.");
    }

    public E persistNewUser(E user, boolean encryptPassword) {
        if (((PersistentObject)user).getId() != null) {
            return user;
        }
        if (encryptPassword) {
            ((User)user).setPassword(this.passwordEncoder.encode((CharSequence)((User)user).getPassword()));
        }
        ((UserDao)this.dao).saveOrUpdate(user);
        return user;
    }

    public void updatePassword(E user, String rawPassword) throws Exception {
        if (((PersistentObject)user).getId() == null) {
            throw new Exception("The ID of the user object is null.");
        }
        ((User)user).setPassword(this.passwordEncoder.encode((CharSequence)rawPassword));
        ((UserDao)this.dao).saveOrUpdate(user);
    }

    @Transactional(readOnly=true)
    public E getUserBySession() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (!(principal instanceof User)) {
            return null;
        }
        User loggedInUser = (User)principal;
        Integer id = loggedInUser.getId();
        return (E)((User)((UserDao)this.dao).findById(id));
    }

    @PostFilter(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(filterObject, 'READ')")
    @Transactional(readOnly=true)
    public Set<UserGroup> getGroupsOfUser(Integer userId) throws Exception {
        User user = (User)this.findById(userId);
        if (user != null) {
            logger.trace("Found user with ID " + user.getId());
            Set<UserGroup> userGroupsSet = user.getUserGroups();
            return userGroupsSet;
        }
        throw new Exception("The user with id " + userId + " could not be found");
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public Role getDefaultUserRole() {
        return this.defaultUserRole;
    }

    public void setDefaultUserRole(Role defaultUserRole) {
        this.defaultUserRole = defaultUserRole;
    }
}

