/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor;

import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WmtsUtil {
    private static final Logger LOG = LogManager.getLogger(WmtsUtil.class);

    public static boolean isRestfulWmtsRequest(MutableHttpServletRequest mutableRequest) {
        String url = mutableRequest.getRequestURL().toString();
        boolean defaultRestfulRequest = Pattern.compile("[^\\/]*\\/[^\\/]*[^\\/]\\/\\d+\\/\\d+").matcher(url).find();
        boolean isWmtsUrl = Pattern.compile(".*/geoserver.action/.*/wmts/\\d+/(.*)").matcher(url).matches();
        return defaultRestfulRequest && isWmtsUrl;
    }

    public static boolean isRestfulWmtsGetFeatureinfo(MutableHttpServletRequest mutableRequest) {
        if (!WmtsUtil.isRestfulWmtsRequest(mutableRequest)) {
            return false;
        }
        String url = mutableRequest.getRequestURL().toString();
        return !WmtsUtil.isRestfulWmtsGetTile(mutableRequest) && Pattern.compile("\\/\\d+\\/\\d+\\/\\d+\\/\\d+").matcher(url).find();
    }

    public static boolean isRestfulWmtsGetTile(MutableHttpServletRequest mutableRequest) {
        if (!WmtsUtil.isRestfulWmtsRequest(mutableRequest)) {
            return false;
        }
        String url = mutableRequest.getRequestURL().toString();
        String format = mutableRequest.getParameterIgnoreCase("format");
        return format == null ? url.endsWith(".png") || url.endsWith(".jpg") || url.endsWith(".jpeg") || url.endsWith(".gif") : format.toLowerCase(Locale.ROOT).contains("image");
    }

    public static String getLayerId(MutableHttpServletRequest mutableRequest) {
        try {
            String part = mutableRequest.getRequestURL().toString().split("/wmts/")[1];
            return part.split("/")[0];
        }
        catch (Exception e) {
            return null;
        }
    }
}

