/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor.secure;

import de.terrestris.shoguncore.dao.LayerDao;
import de.terrestris.shoguncore.dao.UserDao;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.model.layer.source.ImageWmsLayerDataSource;
import de.terrestris.shoguncore.model.layer.source.LayerDataSource;
import de.terrestris.shoguncore.model.layer.source.WfsLayerDataSource;
import de.terrestris.shoguncore.model.security.Permission;
import de.terrestris.shoguncore.model.security.PermissionCollection;
import de.terrestris.shoguncore.service.LayerService;
import de.terrestris.shoguncore.service.UserService;
import de.terrestris.shoguncore.util.enumeration.OgcEnum;
import de.terrestris.shoguncore.util.interceptor.GeoserverAuthHeaderRequest;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.WfsRequestInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.secure.BaseInterceptor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class WfsRequestInterceptor
extends BaseInterceptor
implements WfsRequestInterceptorInterface {
    private static final Logger LOG = LogManager.getLogger(WfsRequestInterceptor.class);
    @Autowired
    @Qualifier(value="userService")
    protected UserService<User, UserDao<User>> userService;
    @Autowired
    @Qualifier(value="layerService")
    protected LayerService<Layer, LayerDao<Layer>> layerService;
    @Value(value="${geoserver.username:}")
    private String gsUser;
    @Value(value="${geoserver.password:}")
    private String gsPass;

    @Override
    public MutableHttpServletRequest interceptGetCapabilities(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS GetCapabilities");
        return new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptDescribeFeatureType(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS DescribeFeatureType");
        return new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptGetFeature(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS GetFeature");
        return this.isAllowed(request, "READ") ? new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass) : this.forbidRequest(request);
    }

    @Override
    public MutableHttpServletRequest interceptLockFeature(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS LockFeature");
        return this.isAllowed(request, "UPDATE") ? new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass) : this.forbidRequest(request);
    }

    @Override
    public MutableHttpServletRequest interceptTransaction(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS Transaction");
        return this.isAllowed(request, "UPDATE") ? new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass) : this.forbidRequest(request);
    }

    private boolean isAllowed(MutableHttpServletRequest request, String paramName, String method) {
        String typeNameParam = request.getParameterIgnoreCase(paramName);
        List all = this.layerService.findAll();
        boolean match = false;
        for (Layer layer : all) {
            LayerDataSource source;
            if (layer.getSource() instanceof WfsLayerDataSource) {
                source = (WfsLayerDataSource)layer.getSource();
                if (!((WfsLayerDataSource)source).getTypeName().equalsIgnoreCase(typeNameParam) && !((WfsLayerDataSource)source).getTypeNames().equalsIgnoreCase(typeNameParam) || !source.getUrl().equalsIgnoreCase(request.getContextPath() + "/geoserver.action")) continue;
                if (method.equals("UPDATE")) {
                    match = this.checkForPermission(layer, Permission.UPDATE);
                    break;
                }
                if (!method.equals("READ")) break;
                match = true;
                break;
            }
            if (!(layer.getSource() instanceof ImageWmsLayerDataSource) || !((ImageWmsLayerDataSource)(source = (ImageWmsLayerDataSource)layer.getSource())).getLayerNames().equalsIgnoreCase(typeNameParam) || !source.getUrl().equalsIgnoreCase(request.getContextPath() + "/geoserver.action")) continue;
            if (method.equals("UPDATE")) {
                match = this.checkForPermission(layer, Permission.UPDATE);
                break;
            }
            if (!method.equals("READ")) break;
            match = true;
            break;
        }
        return match;
    }

    private boolean isAllowed(MutableHttpServletRequest request, String method) {
        String typeNameParam = OgcEnum.EndPoint.TYPENAMES.toString();
        if (StringUtils.isEmpty((CharSequence)request.getParameterIgnoreCase(typeNameParam))) {
            typeNameParam = OgcEnum.EndPoint.TYPENAME.toString();
        }
        return this.isAllowed(request, typeNameParam, method);
    }

    private boolean checkForPermission(Layer layer, Permission permission) {
        Map<User, PermissionCollection> up = layer.getUserPermissions();
        Map<UserGroup, PermissionCollection> gp = layer.getGroupPermissions();
        User user = this.userService.getUserBySession();
        boolean hasUser = up.containsKey(user);
        boolean allowedOnUser = false;
        if (hasUser) {
            PermissionCollection pc = up.get(user);
            allowedOnUser = pc.getPermissions().contains((Object)permission);
        }
        boolean allowedOnGroup = false;
        Set<UserGroup> groups = user.getUserGroups();
        if (groups != null) {
            for (UserGroup group : groups) {
                if (!gp.containsKey(group) || allowedOnGroup) continue;
                allowedOnGroup = gp.get(group).getPermissions().contains((Object)permission);
            }
        }
        return allowedOnUser || allowedOnGroup;
    }
}

