/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor.secure;

import de.terrestris.shoguncore.dao.LayerDao;
import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.model.layer.source.ImageWmsLayerDataSource;
import de.terrestris.shoguncore.model.layer.source.LayerDataSource;
import de.terrestris.shoguncore.model.layer.source.WfsLayerDataSource;
import de.terrestris.shoguncore.service.LayerService;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.WfsResponseInterceptorInterface;
import de.terrestris.shoguncore.util.model.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.deegree.commons.xml.CommonNamespaces;
import org.deegree.commons.xml.NamespaceBindings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WfsResponseInterceptor
implements WfsResponseInterceptorInterface {
    private static final Logger LOG = LogManager.getLogger(WfsResponseInterceptor.class);
    @Autowired
    @Qualifier(value="layerService")
    protected LayerService<Layer, LayerDao<Layer>> layerService;

    private void interceptGetCapabilities100(Document doc, String baseUrl) throws XPathExpressionException {
        Element node;
        int i;
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList list = (NodeList)xpath.compile("//*[local-name()=\"Get\"]").evaluate(doc.getDocumentElement(), XPathConstants.NODESET);
        for (i = 0; i < list.getLength(); ++i) {
            node = (Element)list.item(i);
            node.setAttribute("onlineResource", baseUrl);
        }
        list = (NodeList)xpath.compile("//*[local-name()=\"Post\"]").evaluate(doc.getDocumentElement(), XPathConstants.NODESET);
        for (i = 0; i < list.getLength(); ++i) {
            node = (Element)list.item(i);
            node.setAttribute("onlineResource", baseUrl);
        }
    }

    private void interceptGetCapabilities110And200(Document doc, String baseUrl, String owsNamespace) throws XPathExpressionException {
        Element node;
        int i;
        NamespaceBindings nscontext = new NamespaceBindings();
        nscontext.addNamespace("ows", owsNamespace);
        nscontext.addNamespace("xlink", "http://www.w3.org/1999/xlink");
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)nscontext);
        NodeList list = (NodeList)xpath.compile("//ows:Get").evaluate(doc.getDocumentElement(), XPathConstants.NODESET);
        for (i = 0; i < list.getLength(); ++i) {
            node = (Element)list.item(i);
            node.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", baseUrl);
        }
        list = (NodeList)xpath.compile("//ows:Post").evaluate(doc.getDocumentElement(), XPathConstants.NODESET);
        for (i = 0; i < list.getLength(); ++i) {
            node = (Element)list.item(i);
            node.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", baseUrl);
        }
    }

    @Override
    public Response interceptGetCapabilities(MutableHttpServletRequest request, Response response) {
        LOG.debug("Intercepting WFS GetCapabilities response");
        String proto = request.getHeader("x-forwarded-proto");
        String requestHost = request.getHeader("x-forwarded-host");
        if (StringUtils.isEmpty((CharSequence)proto)) {
            proto = request.getScheme();
        }
        if (StringUtils.isEmpty((CharSequence)requestHost)) {
            requestHost = request.getServerName();
        }
        String baseUrl = proto + "://" + requestHost + request.getContextPath() + "/geoserver.action";
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            String version;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(response.getBody()));
            Element root = doc.getDocumentElement();
            switch (version = root.getAttribute("version")) {
                case "1.0.0": {
                    this.interceptGetCapabilities100(doc, baseUrl);
                    break;
                }
                case "1.1.0": {
                    this.interceptGetCapabilities110And200(doc, baseUrl, "http://www.opengis.net/ows");
                    break;
                }
                case "2.0.0": {
                    this.interceptGetCapabilities110And200(doc, baseUrl, "http://www.opengis.net/ows/1.1");
                    break;
                }
                default: {
                    throw new IOException("WFS version is not supported");
                }
            }
            this.removeLayers(doc);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(bout));
            response.setBody(bout.toByteArray());
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            LOG.warn("Problem when intercepting WFS GetCapabilities: {}", (Object)e.getMessage());
            LOG.trace("Stack trace:", (Throwable)e);
            return null;
        }
        return response;
    }

    private void removeLayers(Document doc) throws XPathExpressionException {
        List layers = this.layerService.findAll();
        ArrayList<String> layerNames = new ArrayList<String>();
        for (Layer layer : layers) {
            LayerDataSource source;
            if (layer.getSource() instanceof ImageWmsLayerDataSource) {
                source = (ImageWmsLayerDataSource)layer.getSource();
                layerNames.add(((ImageWmsLayerDataSource)source).getLayerNames());
                continue;
            }
            if (!(layer.getSource() instanceof WfsLayerDataSource)) continue;
            source = (WfsLayerDataSource)layer.getSource();
            layerNames.add(((WfsLayerDataSource)source).getTypeName());
            layerNames.add(((WfsLayerDataSource)source).getTypeNames());
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)CommonNamespaces.getNamespaceContext().addNamespace("wfs", "http://www.opengis.net/wfs"));
        NodeList list = (NodeList)xpath.compile("//wfs:FeatureType/wfs:Name").evaluate(doc.getDocumentElement(), XPathConstants.NODESET);
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element name = (Element)list.item(i);
            String str = name.getTextContent();
            if (layerNames.contains(str)) continue;
            toRemove.add((Element)name.getParentNode());
        }
        toRemove.forEach(element -> element.getParentNode().removeChild((Node)element));
    }

    @Override
    public Response interceptDescribeFeatureType(MutableHttpServletRequest request, Response response) {
        LOG.debug("Intercepting WFS DescribeFeatureType response");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(response.getBody()));
            this.removeFeatureTypes(doc);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(bout));
            response.setBody(bout.toByteArray());
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            LOG.warn("Problem when intercepting WFS GetCapabilities: {}", (Object)e.getMessage());
            LOG.trace("Stack trace:", (Throwable)e);
            return null;
        }
        return response;
    }

    private void removeFeatureTypes(Document doc) throws XPathExpressionException {
        String str;
        Element name;
        int i;
        List layers = this.layerService.findAll();
        ArrayList<String> layerNames = new ArrayList<String>();
        for (Layer layer : layers) {
            LayerDataSource source;
            if (layer.getSource() instanceof ImageWmsLayerDataSource) {
                source = (ImageWmsLayerDataSource)layer.getSource();
                if (((ImageWmsLayerDataSource)source).getLayerNames().contains(":")) {
                    layerNames.add(((ImageWmsLayerDataSource)source).getLayerNames().split(":")[1]);
                    continue;
                }
                layerNames.add(((ImageWmsLayerDataSource)source).getLayerNames());
                continue;
            }
            if (!(layer.getSource() instanceof WfsLayerDataSource)) continue;
            source = (WfsLayerDataSource)layer.getSource();
            if (((WfsLayerDataSource)source).getTypeName().contains(":")) {
                layerNames.add(((WfsLayerDataSource)source).getTypeName().split(":")[1]);
            } else {
                layerNames.add(((WfsLayerDataSource)source).getTypeName());
            }
            if (((WfsLayerDataSource)source).getTypeNames().contains(":")) {
                layerNames.add(((WfsLayerDataSource)source).getTypeNames().split(":")[1]);
                continue;
            }
            layerNames.add(((WfsLayerDataSource)source).getTypeNames());
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)CommonNamespaces.getNamespaceContext().addNamespace("wfs", "http://www.opengis.net/wfs").addNamespace("xsd", "http://www.w3.org/2001/XMLSchema"));
        NodeList list = (NodeList)xpath.compile("//xsd:complexType").evaluate(doc.getDocumentElement(), XPathConstants.NODESET);
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (i = 0; i < list.getLength(); ++i) {
            name = (Element)list.item(i);
            str = name.getAttribute("name");
            if (layerNames.contains(str = str.substring(0, str.lastIndexOf("Type")))) continue;
            toRemove.add(name);
        }
        list = (NodeList)xpath.compile("/xsd:schema/xsd:element").evaluate(doc.getDocumentElement(), XPathConstants.NODESET);
        for (i = 0; i < list.getLength(); ++i) {
            name = (Element)list.item(i);
            str = name.getAttribute("name");
            if (layerNames.contains(str)) continue;
            toRemove.add(name);
        }
        toRemove.forEach(element -> element.getParentNode().removeChild((Node)element));
    }

    @Override
    public Response interceptGetFeature(MutableHttpServletRequest request, Response response) {
        LOG.debug("Intercepting WFS GetFeature response");
        return response;
    }

    @Override
    public Response interceptLockFeature(MutableHttpServletRequest request, Response response) {
        LOG.debug("Intercepting WFS LockFeature response");
        return response;
    }

    @Override
    public Response interceptTransaction(MutableHttpServletRequest request, Response response) {
        LOG.debug("Intercepting WFS Transaction response");
        return response;
    }
}

