/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor.secure;

import de.terrestris.shoguncore.dao.LayerDao;
import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.model.layer.source.ImageWmsLayerDataSource;
import de.terrestris.shoguncore.service.LayerService;
import de.terrestris.shoguncore.util.interceptor.GeoserverAuthHeaderRequest;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.WmsRequestInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.secure.BaseInterceptor;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class WmsRequestInterceptor
extends BaseInterceptor
implements WmsRequestInterceptorInterface {
    private static final Logger LOG = LogManager.getLogger(WmsRequestInterceptor.class);
    @Autowired
    @Qualifier(value="layerService")
    protected LayerService<Layer, LayerDao<Layer>> layerService;
    @Value(value="${geoserver.username:}")
    private String gsUser;
    @Value(value="${geoserver.password:}")
    private String gsPass;

    @Override
    public MutableHttpServletRequest interceptGetMap(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetMap request");
        return this.isAllowed(request) ? new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass) : this.forbidRequest(request);
    }

    @Override
    public MutableHttpServletRequest interceptGetFeatureInfo(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetFeatureInfo request");
        return this.isAllowed(request) ? new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass) : this.forbidRequest(request);
    }

    @Override
    public MutableHttpServletRequest interceptDescribeLayer(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS DescribeLayer request");
        return this.isAllowed(request) ? new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass) : this.forbidRequest(request);
    }

    @Override
    public MutableHttpServletRequest interceptGetLegendGraphic(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetLegendGraphic request");
        return this.isAllowed(request, "layer") ? new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass) : this.forbidRequest(request);
    }

    @Override
    public MutableHttpServletRequest interceptGetStyles(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetStyles request");
        return this.isAllowed(request) ? new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass) : this.forbidRequest(request);
    }

    @Override
    public MutableHttpServletRequest interceptGetCapabilities(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetCapabilities request");
        return new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    private boolean isAllowed(MutableHttpServletRequest request, String paramName) {
        String layersParam = request.getParameterIgnoreCase(paramName);
        List all = this.layerService.findAll();
        boolean match = false;
        for (Layer layer : all) {
            ImageWmsLayerDataSource source;
            if (!(layer.getSource() instanceof ImageWmsLayerDataSource) || !(source = (ImageWmsLayerDataSource)layer.getSource()).getLayerNames().equalsIgnoreCase(layersParam) || !source.getUrl().equalsIgnoreCase(request.getContextPath() + "/geoserver.action")) continue;
            match = true;
            break;
        }
        return match;
    }

    private boolean isAllowed(MutableHttpServletRequest request) {
        return this.isAllowed(request, "layers");
    }
}

