/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor.secure;

import de.terrestris.shoguncore.dao.LayerDao;
import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.model.layer.source.ImageWmsLayerDataSource;
import de.terrestris.shoguncore.service.LayerService;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.WmsResponseInterceptorInterface;
import de.terrestris.shoguncore.util.model.Response;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transactional;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.deegree.commons.xml.CommonNamespaces;
import org.deegree.commons.xml.NamespaceBindings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WmsResponseInterceptor
implements WmsResponseInterceptorInterface {
    private static final Logger LOG = LogManager.getLogger(WmsResponseInterceptor.class);
    @Autowired
    @Qualifier(value="layerService")
    protected LayerService<Layer, LayerDao<Layer>> layerService;

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public Response interceptGetCapabilities(MutableHttpServletRequest request, Response response) {
        String endpoint = request.getParameterIgnoreCase("CUSTOM_ENDPOINT");
        if (endpoint == null) {
            return null;
        }
        List layers = this.layerService.findAll();
        ArrayList<String> layerNames = new ArrayList<String>();
        for (Layer layer : layers) {
            if (!(layer.getSource() instanceof ImageWmsLayerDataSource)) continue;
            ImageWmsLayerDataSource source = (ImageWmsLayerDataSource)layer.getSource();
            layerNames.add(source.getLayerNames());
        }
        byte[] body = response.getBody();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(body));
            Element root = doc.getDocumentElement();
            String version = root.getAttribute("version");
            String proto = request.getHeader("x-forwarded-proto");
            String host = request.getHeader("x-forwarded-host");
            if (StringUtils.isEmpty((CharSequence)proto)) {
                proto = request.getScheme();
            }
            if (StringUtils.isEmpty((CharSequence)host)) {
                host = request.getServerName();
            }
            String baseUrl = proto + "://" + host + request.getParameter("CONTEXT_PATH") + "/geoserver.action/" + endpoint;
            if (version.equals("1.3.0")) {
                this.removeLayers(doc, "http://www.opengis.net/wms", layerNames);
                this.updateUrls(doc, "http://www.opengis.net/wms", baseUrl);
            } else {
                this.removeLayers(doc, "", layerNames);
                this.updateUrls(doc, "", baseUrl);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            transformer.transform(source, result);
            response.setBody(bos.toByteArray());
        }
        catch (Throwable e) {
            LOG.warn("Something went wrong when intercepting a get capabilities response: " + e.getMessage());
            LOG.trace("Stack trace", e);
            return null;
        }
        return response;
    }

    @Override
    public Response interceptGetMap(MutableHttpServletRequest mutableRequest, Response response) {
        return response;
    }

    @Override
    public Response interceptGetFeatureInfo(MutableHttpServletRequest mutableRequest, Response response) {
        return response;
    }

    @Override
    public Response interceptDescribeLayer(MutableHttpServletRequest mutableRequest, Response response) {
        return response;
    }

    @Override
    public Response interceptGetLegendGraphic(MutableHttpServletRequest mutableRequest, Response response) {
        return response;
    }

    @Override
    public Response interceptGetStyles(MutableHttpServletRequest mutableRequest, Response response) {
        return response;
    }

    @SuppressFBWarnings(value={"UC_USELESS_OBJECT"})
    private void removeLayers(Document doc, String namespace, List<String> layerNames) throws XPathExpressionException {
        ArrayList<String> unqualifiedLayerNames = new ArrayList<String>();
        for (String name : layerNames) {
            if (name.contains(":")) {
                unqualifiedLayerNames.add(name.split(":")[1]);
                continue;
            }
            unqualifiedLayerNames.add(name);
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NamespaceBindings nscontext = CommonNamespaces.getNamespaceContext();
        xpath.setNamespaceContext((NamespaceContext)nscontext);
        String prefix = namespace.equals("") ? "" : "wms:";
        XPathExpression expr = xpath.compile("//" + prefix + "Layer/" + prefix + "Name");
        NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element name = (Element)nodeList.item(i);
            String str = name.getTextContent();
            if (!unqualifiedLayerNames.contains(str)) {
                toRemove.add((Element)name.getParentNode());
                continue;
            }
            String nodeLayerName = name.getTextContent();
            for (int j = 0; j < layerNames.size(); ++j) {
                String qualifiedLayerName = layerNames.get(j);
                if (qualifiedLayerName.contains(":")) {
                    String layerNamespace = qualifiedLayerName.split(":")[0];
                    String unqualifiedLayerName = qualifiedLayerName.split(":")[1];
                    if (!nodeLayerName.equals(unqualifiedLayerName)) continue;
                    name.setTextContent(layerNamespace + ":" + name.getTextContent());
                    continue;
                }
                if (!nodeLayerName.equals(qualifiedLayerName)) continue;
                name.setTextContent(name.getTextContent());
            }
        }
        toRemove.forEach(element -> element.getParentNode().removeChild((Node)element));
    }

    private void updateUrls(Document doc, String namespace, String baseUrl) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NamespaceBindings nscontext = CommonNamespaces.getNamespaceContext();
        xpath.setNamespaceContext((NamespaceContext)nscontext);
        String prefix = namespace.equals("") ? "" : "wms:";
        XPathExpression expr = xpath.compile("//" + prefix + "OnlineResource");
        NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element link = (Element)nodeList.item(i);
            String url = link.getAttributeNS("http://www.w3.org/1999/xlink", "xlink:href");
            int index = url.indexOf("?");
            if (index > -1) {
                url = url.substring(index);
                url = baseUrl + url;
                link.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", url);
                continue;
            }
            link.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", baseUrl);
        }
    }
}

