/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor.secure;

import de.terrestris.shoguncore.dao.LayerDao;
import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.service.LayerService;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.WmtsRequestInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.WmtsUtil;
import de.terrestris.shoguncore.util.interceptor.secure.BaseInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class WmtsRequestInterceptor
extends BaseInterceptor
implements WmtsRequestInterceptorInterface {
    private static final Logger LOG = LogManager.getLogger(WmtsRequestInterceptor.class);
    @Autowired
    @Qualifier(value="layerService")
    protected LayerService<Layer, LayerDao<Layer>> layerService;

    @Override
    public MutableHttpServletRequest interceptGetTile(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMTS GetTile request");
        Layer layer = this.isAllowed(request);
        if (layer == null) {
            return this.forbidRequest(request);
        }
        String url = layer.getSource().getUrl();
        String layerId = WmtsUtil.getLayerId(request);
        url = url + request.getRequestURL().toString().split("/wmts/" + layerId)[1];
        request.setRequestURI(url);
        return request;
    }

    @Override
    public MutableHttpServletRequest interceptGetFeatureInfo(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMTS GetFeatureInfo request");
        Layer layer = this.isAllowed(request);
        if (layer == null) {
            return this.forbidRequest(request);
        }
        String url = layer.getSource().getUrl();
        String layerId = WmtsUtil.getLayerId(request);
        url = url + request.getRequestURL().toString().split("/wmts/" + layerId)[1];
        request.setRequestURI(url);
        return request;
    }

    @Override
    public MutableHttpServletRequest interceptGetCapabilities(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMTS GetCapabilities request");
        String url = request.getRequestURI().split("/ows")[0] + "/gwc/service/wmts?REQUEST=GetCapabilities";
        request.setRequestURI(url);
        return request;
    }

    private Layer isAllowed(MutableHttpServletRequest request) {
        return (Layer)this.layerService.findById(Integer.parseInt(WmtsUtil.getLayerId(request)));
    }
}

