/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.web;

import de.terrestris.shoguncore.dao.PluginDao;
import de.terrestris.shoguncore.model.Plugin;
import de.terrestris.shoguncore.service.PluginService;
import de.terrestris.shoguncore.util.data.ResultSet;
import de.terrestris.shoguncore.web.AbstractWebController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/plugins"})
public class PluginController<E extends Plugin, D extends PluginDao<E>, S extends PluginService<E, D>>
extends AbstractWebController<E, D, S> {
    public PluginController() {
        this(Plugin.class);
    }

    protected PluginController(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="pluginService")
    public void setService(S service) {
        this.service = service;
    }

    @RequestMapping(value={"preCheckDelete.action"}, method={RequestMethod.POST})
    public ResponseEntity<?> preCheckDelete(@RequestParam(value="pluginId") Integer pluginId) {
        List<String> result = null;
        try {
            result = ((PluginService)this.service).preCheckDelete(pluginId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            logger.error("Could not pre-check plugin deletion: " + msg);
            return new ResponseEntity(ResultSet.error(msg), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(ResultSet.success(result), HttpStatus.OK);
    }
}

