/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@NotNullByDefault(value=false)
public class FixedLengthInputStream
extends FilterInputStream {
    private final long limit;
    private long count;

    public FixedLengthInputStream(InputStream in, long limit) {
        super(in);
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.count >= this.limit) {
            return -1;
        }
        int res = super.read();
        if (res == -1) {
            throw new EOFException();
        }
        ++this.count;
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.count + (long)len > this.limit && (len = (int)(this.limit - this.count)) == 0) {
            this.in.available();
            return -1;
        }
        int res = super.read(b, off, len);
        if (res == -1) {
            throw new EOFException("Input ended after " + this.count + " bytes; expected " + this.limit);
        }
        this.count += (long)res;
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > this.limit - this.count) {
            n = this.limit - this.count;
        }
        return super.skip(n);
    }

    @Override
    public void close() {
    }
}

