/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import java.util.Collection;
import java.util.Map;

public final class PredicateUtil {
    private static final Predicate ALWAYS = new Predicate(){

        @Override
        public boolean evaluate(Object subject) {
            return true;
        }

        public String toString() {
            return "ALWAYS";
        }
    };
    private static final Predicate NEVER = new Predicate(){

        @Override
        public boolean evaluate(Object subject) {
            return false;
        }

        public String toString() {
            return "NEVER";
        }
    };

    private PredicateUtil() {
    }

    public static <T> Predicate<T> always(boolean value) {
        return value ? PredicateUtil.always() : PredicateUtil.never();
    }

    public static <T> Predicate<T> always() {
        return ALWAYS;
    }

    public static <T> Predicate<T> never() {
        return NEVER;
    }

    @Deprecated
    public static <T> Predicate<T> atMostEvery(long milliseconds) {
        return PredicateUtil.ignoreSubject(ProducerUtil.atMostEvery(milliseconds));
    }

    public static <T> Predicate<T> and(final Predicate<? super T> lhs, final Predicate<? super T> rhs) {
        if (lhs == NEVER || rhs == NEVER) {
            return NEVER;
        }
        if (lhs == ALWAYS) {
            return rhs;
        }
        if (rhs == ALWAYS) {
            return lhs;
        }
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return lhs.evaluate(subject) && rhs.evaluate(subject);
            }

            public String toString() {
                return lhs + " && " + rhs;
            }
        };
    }

    public static <T> Predicate<T> and(Predicate<? super T> lhs, boolean rhs) {
        return !rhs ? NEVER : (lhs == ALWAYS ? PredicateUtil.always(rhs) : lhs);
    }

    public static <T> Predicate<T> and(boolean lhs, Predicate<? super T> rhs) {
        return !lhs ? NEVER : (rhs == ALWAYS ? PredicateUtil.always(lhs) : rhs);
    }

    public static <T> Predicate<T> or(final Predicate<? super T> lhs, final Predicate<? super T> rhs) {
        if (lhs == ALWAYS || rhs == ALWAYS) {
            return ALWAYS;
        }
        if (lhs == NEVER) {
            return rhs;
        }
        if (rhs == NEVER) {
            return lhs;
        }
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return lhs.evaluate(subject) || rhs.evaluate(subject);
            }

            public String toString() {
                return lhs + " || " + rhs;
            }
        };
    }

    public static <T> Predicate<T> or(Predicate<? super T> lhs, boolean rhs) {
        return rhs ? ALWAYS : (lhs == NEVER ? PredicateUtil.always(rhs) : lhs);
    }

    public static <T> Predicate<T> or(boolean lhs, Predicate<? super T> rhs) {
        return lhs ? ALWAYS : (rhs == NEVER ? PredicateUtil.always(lhs) : rhs);
    }

    public static <T> Predicate<T> xor(final Predicate<? super T> lhs, final Predicate<? super T> rhs) {
        if (lhs == ALWAYS) {
            if (rhs == ALWAYS) {
                return NEVER;
            }
            if (rhs == NEVER) {
                return ALWAYS;
            }
        }
        if (lhs == NEVER) {
            if (rhs == ALWAYS) {
                return ALWAYS;
            }
            if (rhs == NEVER) {
                return NEVER;
            }
        }
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return lhs.evaluate(subject) ^ rhs.evaluate(subject);
            }

            public String toString() {
                return lhs + " ^ " + rhs;
            }
        };
    }

    public static <T> Predicate<T> xor(Predicate<? super T> lhs, boolean rhs) {
        return rhs ? PredicateUtil.not(lhs) : lhs;
    }

    public static <T> Predicate<T> xor(boolean lhs, Predicate<? super T> rhs) {
        return lhs ? PredicateUtil.not(rhs) : rhs;
    }

    public static <T> Predicate<T> not(final Predicate<? super T> delegate) {
        if (delegate == NEVER) {
            return PredicateUtil.always();
        }
        if (delegate == ALWAYS) {
            return PredicateUtil.never();
        }
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return !delegate.evaluate(subject);
            }

            public String toString() {
                return "!" + delegate;
            }
        };
    }

    public static <T> Predicate<T> not(boolean value) {
        return PredicateUtil.always(!value);
    }

    public static <C extends Comparable<C>> Predicate<C> less(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) > 0;
            }

            public String toString() {
                return "< " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> lessEqual(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) >= 0;
            }

            public String toString() {
                return "<= " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> greater(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) < 0;
            }

            public String toString() {
                return "> " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> greaterEqual(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) <= 0;
            }

            public String toString() {
                return ">= " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> equal(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) == 0;
            }

            public String toString() {
                return "== " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> notEqual(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) != 0;
            }

            public String toString() {
                return "!= " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> between(final C min, final C max) {
        return max.compareTo(min) >= 0 ? new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return min.compareTo(subject) <= 0 && max.compareTo(subject) >= 0;
            }

            public String toString() {
                return min + "-" + max;
            }
        } : new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return min.compareTo(subject) >= 0 || max.compareTo(subject) <= 0;
            }

            public String toString() {
                return min + "-" + max;
            }
        };
    }

    public static <T> Predicate<T> equal(final T other) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return other.equals(subject);
            }

            public String toString() {
                return "eq " + other;
            }
        };
    }

    public static <T> Predicate<T> notEqual(final T other) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return !other.equals(subject);
            }

            public String toString() {
                return "nq " + other;
            }
        };
    }

    @Deprecated
    public static Predicate<Object> after(long expirationTime) {
        return PredicateUtil.ignoreSubject(ProducerUtil.after(expirationTime));
    }

    public static <T extends Predicate<String>> T forString(final String format, final T delegate) {
        Predicate<String> result = new Predicate<String>(){

            @Override
            public boolean evaluate(String subject) {
                return delegate.evaluate(format.replace("*", subject));
            }
        };
        return (T)result;
    }

    public static <T, EX extends Throwable> PredicateWhichThrows<T, EX> asPredicateWhichThrows(final Predicate<? super T> source) {
        return new PredicateWhichThrows<T, EX>(){

            @Override
            public boolean evaluate(T subject) {
                return source.evaluate(subject);
            }
        };
    }

    public static <T, EX extends RuntimeException> Predicate<T> asPredicate(final PredicateWhichThrows<T, EX> source) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return source.evaluate(subject);
            }
        };
    }

    public static <T> Predicate<T> contains(final Collection<? extends T> collection) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return collection.contains(subject);
            }
        };
    }

    public static <K> Predicate<K> containsKey(final Map<K, ?> map) {
        return new Predicate<K>(){

            @Override
            public boolean evaluate(K subject) {
                return map.containsKey(subject);
            }
        };
    }

    public static <K> Predicate<K> containsKey(final Mapping<K, ?> mapping) {
        return new Predicate<K>(){

            @Override
            public boolean evaluate(K subject) {
                return mapping.containsKey(subject);
            }
        };
    }

    public static <T, EX extends Throwable> PredicateWhichThrows<T, EX> ignoreSubject(final ProducerWhichThrows<Boolean, EX> delegate) {
        return new PredicateWhichThrows<T, EX>(){

            @Override
            public boolean evaluate(T subject) throws Throwable {
                Boolean b = (Boolean)delegate.produce();
                return b != null && b != false;
            }
        };
    }

    public static <T, EX extends Throwable> Predicate<T> ignoreSubject(final Producer<Boolean> delegate) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                Boolean b = (Boolean)delegate.produce();
                return b != null && b != false;
            }
        };
    }

    public static <T, EX extends Throwable> Predicate<T> ignoreExceptions(final Class<EX> exceptionClass, final PredicateWhichThrows<T, EX> delegate, final boolean defaultValue) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                block6: {
                    try {
                        return delegate.evaluate(subject);
                    }
                    catch (RuntimeException re) {
                        if (!exceptionClass.isAssignableFrom(re.getClass())) {
                            throw re;
                        }
                    }
                    catch (Error e) {
                        if (!exceptionClass.isAssignableFrom(e.getClass())) {
                            throw e;
                        }
                    }
                    catch (Throwable t) {
                        if ($assertionsDisabled || exceptionClass.isAssignableFrom(t.getClass())) break block6;
                        throw new AssertionError();
                    }
                }
                return defaultValue;
            }
        };
    }

    public static <T, EX extends Throwable> PredicateWhichThrows<T, EX> synchronizedPredicate(final PredicateWhichThrows<? super T, EX> delegate) {
        return new PredicateWhichThrows<T, EX>(){

            @Override
            public synchronized boolean evaluate(T subject) throws Throwable {
                return delegate.evaluate(subject);
            }
        };
    }
}

