/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text;

import de.unkrig.commons.lang.AssertionUtil;
import java.util.ArrayList;
import java.util.List;

public final class Notations {
    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private Notations() {
    }

    public static Phrase fromCamelCase(String s) {
        int len = s.length();
        int i = 1;
        while (i < len) {
            if (Character.isUpperCase(s.charAt(i))) {
                ArrayList<String> l = new ArrayList<String>(4);
                l.add(s.substring(0, i));
                int to = i + 1;
                while (true) {
                    if (to == len) {
                        l.add(s.substring(i));
                        return new PhraseImpl(l);
                    }
                    if (Character.isUpperCase(s.charAt(to))) {
                        l.add(s.substring(i, to));
                        i = to;
                    }
                    ++to;
                }
            }
            ++i;
        }
        return new PhraseImpl(s);
    }

    public static Phrase fromHyphenated(String s) {
        int idx = s.indexOf(45);
        if (idx == -1) {
            return new PhraseImpl(s);
        }
        ArrayList<String> l = new ArrayList<String>(4);
        l.add(s.substring(0, idx));
        int to = s.indexOf(45, idx + 1);
        while (true) {
            if (to == -1) {
                l.add(s.substring(idx + 1));
                return new PhraseImpl(l);
            }
            l.add(s.substring(idx + 1, to));
            idx = to;
        }
    }

    public static Phrase fromUnderscored(String s) {
        int idx = s.indexOf(95);
        if (idx == -1) {
            return new PhraseImpl(s);
        }
        ArrayList<String> l = new ArrayList<String>(4);
        l.add(s.substring(0, idx));
        int to = s.indexOf(95, idx + 1);
        while (true) {
            if (to == -1) {
                l.add(s.substring(idx + 1));
                return new PhraseImpl(l);
            }
            l.add(s.substring(idx + 1, to));
            idx = to;
        }
    }

    public static interface Phrase {
        public Phrase prepend(String ... var1);

        public Phrase append(String ... var1);

        public String toUpperCamelCase();

        public String toLowerCamelCase();

        public String toUpperCaseHyphenated();

        public String toLowerCaseHyphenated();

        public String toUpperCaseUnderscored();

        public String toLowerCaseUnderscored();
    }

    private static class PhraseImpl
    implements Phrase {
        final String[] words;

        PhraseImpl(String[] words) {
            this.words = words;
        }

        PhraseImpl(List<String> words) {
            this.words = words.toArray(new String[words.size()]);
        }

        PhraseImpl(String word) {
            this.words = new String[]{word};
        }

        @Override
        public Phrase prepend(String ... words) {
            String[] tmp = new String[words.length + this.words.length];
            System.arraycopy(words, 0, tmp, 0, words.length);
            System.arraycopy(this.words, 0, tmp, words.length, this.words.length);
            return new PhraseImpl(tmp);
        }

        @Override
        public Phrase append(String ... words) {
            String[] tmp = new String[this.words.length + words.length];
            System.arraycopy(this.words, 0, tmp, 0, this.words.length);
            System.arraycopy(words, 0, tmp, words.length, words.length);
            return new PhraseImpl(tmp);
        }

        @Override
        public String toUpperCamelCase() {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = this.words;
            int n = this.words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.length() > 0) {
                    sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase());
                }
                ++n2;
            }
            return sb.toString();
        }

        @Override
        public String toLowerCamelCase() {
            if (this.words.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.words[0].toLowerCase());
            int i = 1;
            while (i < this.words.length) {
                String word = this.words[i];
                if (word.length() > 0) {
                    sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase());
                }
                ++i;
            }
            return sb.toString();
        }

        @Override
        public String toUpperCaseHyphenated() {
            int n = this.words.length;
            if (n == 0) {
                return "";
            }
            if (n == 1) {
                return this.words[0].toUpperCase();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.words[0].toUpperCase()).append('-').append(this.words[1].toUpperCase());
            int i = 2;
            while (i < this.words.length) {
                sb.append('-').append(this.words[i].toUpperCase());
                ++i;
            }
            return sb.toString();
        }

        @Override
        public String toLowerCaseHyphenated() {
            int n = this.words.length;
            if (n == 0) {
                return "";
            }
            if (n == 1) {
                return this.words[0].toLowerCase();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.words[0].toLowerCase()).append('-').append(this.words[1].toLowerCase());
            int i = 2;
            while (i < this.words.length) {
                sb.append('-').append(this.words[i].toLowerCase());
                ++i;
            }
            return sb.toString();
        }

        @Override
        public String toUpperCaseUnderscored() {
            int n = this.words.length;
            if (n == 0) {
                return "";
            }
            if (n == 1) {
                return this.words[0].toUpperCase();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.words[0].toUpperCase()).append('_').append(this.words[1].toUpperCase());
            int i = 2;
            while (i < this.words.length) {
                sb.append('_').append(this.words[i].toUpperCase());
                ++i;
            }
            return sb.toString();
        }

        @Override
        public String toLowerCaseUnderscored() {
            int n = this.words.length;
            if (n == 0) {
                return "";
            }
            if (n == 1) {
                return this.words[0].toLowerCase();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.words[0].toLowerCase()).append('_').append(this.words[1].toLowerCase());
            int i = 2;
            while (i < this.words.length) {
                sb.append('_').append(this.words[i].toLowerCase());
                ++i;
            }
            return sb.toString();
        }
    }
}

