/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.text.parser.AbstractParser;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.scanner.StatelessScanner;

public abstract class IntegerPattern {
    private IntegerPattern() {
    }

    public static Predicate<Integer> newPattern(CharSequence pattern) throws ParseException {
        StatelessScanner<TokenType> scanner2 = new StatelessScanner<TokenType>();
        scanner2.addRule("\\d+", TokenType.INTEGER);
        scanner2.addRule("[,\\-]", TokenType.OPERATOR);
        scanner2.setInput(pattern);
        class Parser
        extends AbstractParser<TokenType> {
            Parser(StatelessScanner statelessScanner) {
                super(statelessScanner);
            }

            Predicate<Integer> parseAlternatives() throws ParseException {
                Predicate<Integer> lhs = this.parseRange();
                return this.peekRead(",") ? PredicateUtil.or(lhs, this.parseAlternatives()) : lhs;
            }

            private Predicate<Integer> parseRange() throws ParseException {
                if (this.peekRead("-")) {
                    return PredicateUtil.between(Integer.MIN_VALUE, this.readInt());
                }
                return PredicateUtil.between(this.readInt(), this.peekRead("-") ? this.readInt() : Integer.MAX_VALUE);
            }

            private int readInt() throws ParseException {
                return Integer.parseInt(this.read(TokenType.INTEGER));
            }
        }
        Parser parser = new Parser(scanner2);
        Predicate<Integer> result = parser.parseAlternatives();
        parser.eoi();
        return result;
    }

    private static enum TokenType {
        INTEGER,
        OPERATOR;

    }
}

