/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Notations;
import de.unkrig.commons.text.StringStream;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.text.pattern.Pattern2;
import de.unkrig.commons.text.pattern.PatternUtil;
import de.unkrig.commons.util.CommandLineOptionException;
import de.unkrig.commons.util.IdentityHashSet;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.CommandLineOptionGroup;
import de.unkrig.commons.util.annotation.RegexFlags;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public final class CommandLineOptions {
    private static final Pattern REGEX_OPTION;
    private static final Pattern REGEX_COMPACT_OPTIONS;
    private static final Map<Method, CommandLineOption> METHOD_TO_OPTION;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        REGEX_OPTION = Pattern.compile("-.+");
        REGEX_COMPACT_OPTIONS = Pattern.compile("-([^\\-])(.*)");
        METHOD_TO_OPTION = new WeakHashMap<Method, CommandLineOption>();
    }

    private CommandLineOptions() {
    }

    public static String[] parse(String[] args, Object target) throws CommandLineOptionException {
        StringStream ss = new StringStream(ProducerUtil.fromArray(args));
        Parser p = new Parser(target.getClass());
        p.parseOptions(ss, target);
        if (!ss.peekRead("--") && ss.peek(REGEX_OPTION)) {
            throw new CommandLineOptionException.UnrecognizedOption(AssertionUtil.notNull(ss.group(0)));
        }
        return ss.readRest();
    }

    private static int getRegexFlags(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a.annotationType() == RegexFlags.class) {
                return ((RegexFlags)a).value();
            }
            ++n2;
        }
        return 0;
    }

    @Nullable
    public static Method getMethodForOption(String optionName, Class<?> targetClass) {
        Parser parser = new Parser(targetClass);
        CommandLineOption option = parser.getOption(optionName, targetClass);
        if (option == null) {
            return null;
        }
        return parser.methodFor(option);
    }

    public static int applyCommandLineOption(String optionName, Method method, String[] args, int optionArgumentIndex, @Nullable Object target) throws CommandLineOptionException {
        CommandLineOption option = CommandLineOptions.getOption(method);
        assert (option != null);
        Class<?> targetClass = target != null ? target.getClass() : method.getDeclaringClass();
        ProducerUtil.FromArrayProducer<String> fap = ProducerUtil.fromArray(args, optionArgumentIndex, args.length);
        new Parser(targetClass).applyCommandLineOption(optionName, option, new StringStream(fap), target);
        return fap.index();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static CommandLineOption getOption(Method method) {
        Map<Method, CommandLineOption> map = METHOD_TO_OPTION;
        synchronized (map) {
            CommandLineOption option;
            block5: {
                option = METHOD_TO_OPTION.get(method);
                if (option != null) {
                    return option;
                }
                if (!METHOD_TO_OPTION.containsKey(method)) break block5;
                return null;
            }
            option = method.getAnnotation(CommandLineOption.class);
            METHOD_TO_OPTION.put(method, option);
            return option;
        }
    }

    public static void printResource(Class<?> baseClass, String relativeResourceName, @Nullable Charset resourceCharset, PrintStream printStream) throws IOException {
        String resourceName = String.valueOf(baseClass.getSimpleName()) + "." + relativeResourceName;
        InputStream is = baseClass.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        try {
            OutputStreamWriter w = new OutputStreamWriter(printStream);
            PatternUtil.replaceSystemProperties(resourceCharset == null ? new InputStreamReader(is) : new InputStreamReader(is, resourceCharset), w);
            ((Writer)w).flush();
        }
        finally {
            is.close();
        }
    }

    private static class Parser<EX extends Throwable> {
        private final Map<String, CommandLineOption> allOptions = new LinkedHashMap<String, CommandLineOption>();
        private final Set<CommandLineOption> singularOptions = new IdentityHashSet<CommandLineOption>();
        private final List<CommandLineOption> requiredOptions = new ArrayList<CommandLineOption>();
        private final Set<CommandLineOptionGroup> singularOptionGroups = new IdentityHashSet<CommandLineOptionGroup>();
        private final List<CommandLineOptionGroup> requiredOptionGroups = new ArrayList<CommandLineOptionGroup>();
        private final Map<CommandLineOption, Set<CommandLineOptionGroup>> optionToGroups = new IdentityHashMap<CommandLineOption, Set<CommandLineOptionGroup>>();
        private final Map<CommandLineOption, Method> optionToMethod = new IdentityHashMap<CommandLineOption, Method>();
        private final Set<CommandLineOption> actualOptions = new IdentityHashSet<CommandLineOption>();
        private final Set<CommandLineOptionGroup> actualOptionGroups = new IdentityHashSet<CommandLineOptionGroup>();

        Parser(Class<?> targetClass) {
            Method[] methods = targetClass.getMethods();
            Arrays.sort(methods, new Comparator<Method>(){

                @Override
                @NotNullByDefault(value=false)
                public int compare(Method m1, Method m2) {
                    return m1.toString().compareTo(m2.toString());
                }
            });
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                CommandLineOption option = CommandLineOptions.getOption(m);
                if (option != null) {
                    this.optionToMethod.put(option, m);
                    String[] names = option.name();
                    if (names.length == 0) {
                        String n3 = m.getName();
                        if (n3.startsWith("set")) {
                            n3 = n3.substring(3);
                        } else if (n3.startsWith("add")) {
                            n3 = n3.substring(3);
                        }
                        names = new String[]{Notations.fromCamelCase(n3).toLowerCaseHyphenated()};
                    }
                    Object[] objectArray = names;
                    int n4 = names.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String[] stringArray;
                        String name = objectArray[n5];
                        if (name.startsWith("-")) {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = name;
                        } else {
                            String[] stringArray3 = new String[2];
                            stringArray3[0] = "-" + name;
                            stringArray = stringArray3;
                            stringArray3[1] = "--" + name;
                        }
                        String[] stringArray4 = stringArray;
                        int n6 = stringArray.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            String name2 = stringArray4[n7];
                            CommandLineOption prev = this.allOptions.put(name2, option);
                            assert (prev == null) : "Two methods map to option \"" + name2 + "\"";
                            ++n7;
                        }
                        ++n5;
                    }
                    CommandLineOption.Cardinality c = option.cardinality();
                    if (c == CommandLineOption.Cardinality.MANDATORY || c == CommandLineOption.Cardinality.OPTIONAL) {
                        this.singularOptions.add(option);
                    }
                    if (c == CommandLineOption.Cardinality.MANDATORY || c == CommandLineOption.Cardinality.ONCE_OR_MORE) {
                        this.requiredOptions.add(option);
                    }
                    objectArray = option.group();
                    n4 = objectArray.length;
                    n5 = 0;
                    while (n5 < n4) {
                        Object groupClass = objectArray[n5];
                        CommandLineOptionGroup optionGroup = ((Class)groupClass).getAnnotation(CommandLineOptionGroup.class);
                        if (optionGroup == null) {
                            throw new AssertionError((Object)("Group class \"" + groupClass + "\" lacks the \"@CommandLineOptionGroup\" annotation"));
                        }
                        Set<CommandLineOptionGroup> clogs = this.optionToGroups.get(option);
                        if (clogs == null) {
                            clogs = new HashSet<CommandLineOptionGroup>();
                            this.optionToGroups.put(option, clogs);
                        }
                        clogs.add(optionGroup);
                        CommandLineOptionGroup.Cardinality c2 = optionGroup.cardinality();
                        if (c2 == CommandLineOptionGroup.Cardinality.EXACTLY_ONE || c2 == CommandLineOptionGroup.Cardinality.ZERO_OR_ONE) {
                            this.singularOptionGroups.add(optionGroup);
                        }
                        if (c2 == CommandLineOptionGroup.Cardinality.EXACTLY_ONE || c2 == CommandLineOptionGroup.Cardinality.ONE_OR_MORE) {
                            this.requiredOptionGroups.add(optionGroup);
                        }
                        ++n5;
                    }
                }
                ++n2;
            }
        }

        private void parseOptions(StringStream<EX> ss, Object target) throws EX, CommandLineOptionException {
            while (this.parseNextOption(ss, target)) {
            }
            for (CommandLineOption option : this.requiredOptions) {
                if (this.actualOptions.contains(option)) continue;
                throw new CommandLineOptionException.RequiredOptionMissing(option, this.optionNames(option));
            }
            for (CommandLineOptionGroup optionGroup : this.requiredOptionGroups) {
                if (this.actualOptionGroups.contains(optionGroup)) continue;
                throw new CommandLineOptionException.RequiredOptionGroupMissing(optionGroup, this.optionNames(optionGroup));
            }
        }

        private String[] optionNames(CommandLineOption option) {
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry<String, CommandLineOption> e : this.allOptions.entrySet()) {
                String optionName = e.getKey();
                CommandLineOption o = e.getValue();
                if (o != option) continue;
                result.add(optionName);
            }
            return result.toArray(new String[result.size()]);
        }

        private String[] optionNames(CommandLineOptionGroup optionGroup) {
            ArrayList<String> result = new ArrayList<String>();
            block0: for (Map.Entry<String, CommandLineOption> e : this.allOptions.entrySet()) {
                String optionName = e.getKey();
                CommandLineOption option = e.getValue();
                Class<?>[] classArray = option.group();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> g = classArray[n2];
                    if (g.getAnnotation(CommandLineOptionGroup.class) == optionGroup) {
                        result.add(optionName);
                        continue block0;
                    }
                    ++n2;
                }
            }
            return result.toArray(new String[result.size()]);
        }

        private boolean parseNextOption(StringStream<EX> ss, Object target) throws CommandLineOptionException, EX {
            if (ss.atEnd()) {
                return false;
            }
            if (ss.peek("--")) {
                return false;
            }
            if (ss.peek("-")) {
                return false;
            }
            if (this.parseNextVerboseOption(ss, target)) {
                return true;
            }
            if (ss.peek(REGEX_COMPACT_OPTIONS)) {
                char firstOptionLetter = AssertionUtil.notNull(ss.group(1)).charAt(0);
                String followingOptionLetters = AssertionUtil.notNull(ss.group(2));
                String firstOptionName = "-" + firstOptionLetter;
                CommandLineOption firstOption = this.getOption(firstOptionName, target.getClass());
                if (firstOption != null) {
                    try {
                        ss.read();
                    }
                    catch (StringStream.UnexpectedElementException e) {
                        throw new AssertionError();
                    }
                    this.applyCommandLineOption(firstOptionName, firstOption, ss, target);
                    int i = 0;
                    while (i < followingOptionLetters.length()) {
                        String optionName = "-" + followingOptionLetters.charAt(i);
                        CommandLineOption optionMethod = this.getOption(optionName, target.getClass());
                        if (optionMethod == null) {
                            throw new CommandLineOptionException.UnrecognizedOption(optionName);
                        }
                        this.applyCommandLineOption(optionName, optionMethod, ss, target);
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean parseNextVerboseOption(StringStream<EX> ss, Object target) throws CommandLineOptionException, EX {
            String optionName;
            if (ss.atEnd()) {
                return false;
            }
            try {
                optionName = ss.peek();
            }
            catch (StringStream.UnexpectedElementException uee) {
                throw new AssertionError((Object)uee);
            }
            CommandLineOption option = this.getOption(optionName, target.getClass());
            if (option == null) {
                return false;
            }
            try {
                ss.read();
            }
            catch (StringStream.UnexpectedElementException uee) {
                throw new AssertionError((Object)uee);
            }
            this.applyCommandLineOption(optionName, option, ss, target);
            return true;
        }

        @Nullable
        public CommandLineOption getOption(String optionName, Class<?> targetClass) {
            return this.allOptions.get(optionName);
        }

        private Method methodFor(CommandLineOption option) {
            return AssertionUtil.notNull(this.optionToMethod.get(option), String.valueOf(option.toString()) + "; available are " + this.optionToMethod.keySet());
        }

        public void applyCommandLineOption(String optionName, CommandLineOption option, StringStream<EX> stringStream, @Nullable Object target) throws CommandLineOptionException, EX {
            if (this.singularOptions.contains(option) && this.actualOptions.contains(option)) {
                throw new CommandLineOptionException.DuplicateOption(option, optionName, this.optionNames(option));
            }
            Set<CommandLineOptionGroup> clogs = this.optionToGroups.get(option);
            if (clogs != null) {
                for (CommandLineOptionGroup optionGroup : clogs) {
                    if (!this.singularOptionGroups.contains(optionGroup) || !this.actualOptionGroups.contains(optionGroup)) continue;
                    throw new CommandLineOptionException.ConflictingOptions(optionGroup, option, optionName);
                }
            }
            Method method = this.methodFor(option);
            Class<?>[] methodParametersTypes = method.getParameterTypes();
            Annotation[][] methodParametersAnnotations = method.getParameterAnnotations();
            assert (methodParametersTypes.length == methodParametersAnnotations.length);
            Object[] methodArgs = new Object[methodParametersTypes.length];
            int i = 0;
            while (i < methodArgs.length) {
                try {
                    methodArgs[i] = this.getArgument(stringStream, methodParametersAnnotations[i], methodParametersTypes[i]);
                }
                catch (StringStream.UnexpectedElementException uee) {
                    throw new CommandLineOptionException.OptionArgumentMissing(option, optionName, i);
                }
                ++i;
            }
            try {
                method.invoke(target, methodArgs);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            this.actualOptions.add(option);
            if (clogs != null) {
                for (CommandLineOptionGroup optionGroup : clogs) {
                    this.actualOptionGroups.add(optionGroup);
                }
            }
        }

        private Object getArgument(StringStream<EX> ss, Annotation[] annotations, Class<?> targetType) throws CommandLineOptionException, StringStream.UnexpectedElementException, EX {
            if (targetType.isArray()) {
                Class<?> componentType = targetType.getComponentType();
                ArrayList<Object> elements = new ArrayList<Object>();
                while (!ss.atEnd()) {
                    elements.add(this.getArgument(ss, annotations, componentType));
                }
                int size = elements.size();
                Object result = Array.newInstance(componentType, size);
                if (componentType.isPrimitive()) {
                    int i = 0;
                    while (i < size) {
                        Array.set(result, i, elements.get(i));
                        ++i;
                    }
                } else {
                    System.arraycopy(elements.toArray(), 0, result, 0, size);
                }
                return result;
            }
            if (targetType == Pattern.class) {
                return Pattern2.compile(ss.read(), CommandLineOptions.getRegexFlags(annotations));
            }
            if (targetType == Glob.class) {
                return Glob.compile(ss.read(), CommandLineOptions.getRegexFlags(annotations));
            }
            Constructor<?>[] cs = targetType.getConstructors();
            if (cs.length == 1 && cs[0].getParameterTypes().length == 0) {
                Object bean;
                try {
                    bean = cs[0].newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                super.parseOptions(ss, bean);
                return bean;
            }
            String arg = ss.read();
            try {
                return ObjectUtil.fromString(arg, targetType);
            }
            catch (IllegalArgumentException iae) {
                throw new CommandLineOptionException.ArgumentConversionFailed(arg, targetType, iae);
            }
        }
    }
}

