/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.IteratorUtil;
import de.unkrig.commons.util.collections.MapUtil;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public final class CollectionUtil {
    @Deprecated
    public static final SortedMap EMPTY_SORTED_MAP;
    public static final SortedSet EMPTY_SORTED_SET;
    @Deprecated
    public static final Iterator AT_END;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        EMPTY_SORTED_MAP = MapUtil.EMPTY_SORTED_MAP;
        EMPTY_SORTED_SET = new EmptySortedSet();
        AT_END = IteratorUtil.AT_END;
    }

    private CollectionUtil() {
    }

    @Nullable
    public static <T> T removeFirstFrom(Collection<T> subject) {
        Iterator<T> it = subject.iterator();
        if (!it.hasNext()) {
            return null;
        }
        T result = it.next();
        it.remove();
        return result;
    }

    @Deprecated
    public static <K, V> Map<K, V> map(Object ... keyValuePairs) {
        return MapUtil.map(keyValuePairs);
    }

    @Deprecated
    public static <K, V> Map<K, V> map(K[] keys, V[] values) {
        return MapUtil.map(keys, values);
    }

    @Deprecated
    public static <K, V> HashMap<K, V> hashMapOf(Map.Entry<K, V> ... entries) {
        return MapUtil.hashMapOf(entries);
    }

    @Deprecated
    public static <K, V> HashMap<K, V> hashMapOf(int initialCapacity, Map.Entry<K, V> ... entries) {
        return MapUtil.hashMapOf(initialCapacity, entries);
    }

    @Deprecated
    public static <K, V> TreeMap<K, V> treeMapOf(Map.Entry<K, V> ... entries) {
        return MapUtil.treeMapOf(entries);
    }

    @Deprecated
    public static <K, V, M extends Map<K, V>> M putAll(M subject, Map.Entry<K, V> ... entries) {
        return MapUtil.putAll(subject, entries);
    }

    @Deprecated
    public static <K, V, M extends Map<K, V>> M putAll(M subject, boolean allowDuplicateKeys, Map.Entry<K, V> ... entries) {
        return MapUtil.putAll(subject, allowDuplicateKeys, entries);
    }

    @Deprecated
    public static <K, V> Map.Entry<K, V> entry(K key, V initialValue) {
        return MapUtil.entry(key, initialValue);
    }

    @Deprecated
    public static <K, V> SortedMap<K, V> emptySortedMap() {
        return MapUtil.EMPTY_SORTED_MAP;
    }

    public static <T> SortedSet<T> emptySortedSet() {
        return EMPTY_SORTED_SET;
    }

    public static <T> Collection<T> sorted(Collection<T> collection) {
        Object[] a = collection.toArray();
        Arrays.sort(a);
        return Arrays.asList(a);
    }

    @NotNullByDefault(value=false)
    private static class EmptySortedSet
    extends AbstractSet
    implements SortedSet,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EmptySortedSet() {
        }

        @Override
        public Iterator iterator() {
            return IteratorUtil.AT_END;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        public Comparator comparator() {
            return null;
        }

        public SortedSet subSet(Object from, Object to) {
            return EMPTY_SORTED_SET;
        }

        public SortedSet headSet(Object toElement) {
            return EMPTY_SORTED_SET;
        }

        public SortedSet tailSet(Object fromElement) {
            return EMPTY_SORTED_SET;
        }

        public Object first() {
            throw new NoSuchElementException();
        }

        public Object last() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof SortedSet && ((SortedSet)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

