/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.logging.LogUtil;
import de.unkrig.commons.util.logging.formatter.PrintfFormatter;
import de.unkrig.commons.util.logging.formatter.SelectiveFormatter;
import de.unkrig.commons.util.logging.handler.ProxyHandler;
import de.unkrig.commons.util.logging.handler.StderrHandler;
import de.unkrig.commons.util.logging.handler.StdoutHandler;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleLogging {
    private static final Handler DEBUG_HANDLER;
    private static final ProxyHandler OUT_HANDLER;
    private static final Handler STDERR_HANDLER;
    private static final Formatter DEFAULT_DEBUG_FORMATTER;
    private static final Formatter DEFAULT_OUT_FORMATTER;
    private static final Formatter DEFAULT_STDERR_FORMATTER;
    private static final ExpressionEvaluator HANDLER_INSTANTIATOR;
    private static final ExpressionEvaluator FORMATTER_INSTANTIATOR;

    static {
        DEFAULT_DEBUG_FORMATTER = new PrintfFormatter("%10$27s::%7$-15s %8$s%9$s%n");
        DEFAULT_STDERR_FORMATTER = DEFAULT_OUT_FORMATTER = SelectiveFormatter.loggerLevelGreaterThan(Level.FINE, PrintfFormatter.MESSAGE_AND_EXCEPTION, PrintfFormatter.MESSAGE_AND_STACK_TRACE);
        DEBUG_HANDLER = new StderrHandler();
        DEBUG_HANDLER.setFilter(LogUtil.LESS_THAN_CONFIG);
        DEBUG_HANDLER.setLevel(Level.ALL);
        DEBUG_HANDLER.setFormatter(DEFAULT_DEBUG_FORMATTER);
        LogUtil.ROOT_LOGGER.addHandler(DEBUG_HANDLER);
        OUT_HANDLER = new ProxyHandler(new StdoutHandler());
        OUT_HANDLER.setFilter(LogUtil.LESS_THAN_WARNING);
        OUT_HANDLER.setLevel(Level.CONFIG);
        OUT_HANDLER.setFormatter(DEFAULT_OUT_FORMATTER);
        LogUtil.ROOT_LOGGER.addHandler(OUT_HANDLER);
        STDERR_HANDLER = new StderrHandler();
        STDERR_HANDLER.setLevel(Level.WARNING);
        STDERR_HANDLER.setFormatter(DEFAULT_STDERR_FORMATTER);
        LogUtil.ROOT_LOGGER.addHandler(STDERR_HANDLER);
        Handler[] handlerArray = LogUtil.ROOT_LOGGER.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof ConsoleHandler) {
                handler.close();
                LogUtil.ROOT_LOGGER.removeHandler(handler);
            }
            ++n2;
        }
        SimpleLogging.setNormal();
        HANDLER_INSTANTIATOR = new ExpressionEvaluator(PredicateUtil.never()).setImports(new String[]{"java.util.logging", "de.unkrig.commons.util.logging.handler"});
        FORMATTER_INSTANTIATOR = new ExpressionEvaluator(PredicateUtil.never()).setImports(new String[]{"java.util.logging", "de.unkrig.commons.util.logging.formatter"});
    }

    private SimpleLogging() {
    }

    public static void init() {
    }

    public static synchronized void setLevel(Level level) {
        LogUtil.ROOT_LOGGER.setLevel(level);
    }

    public static Level getLevel() {
        return LogUtil.ROOT_LOGGER.getLevel();
    }

    public static void setFormatter(String spec) throws ParseException, EvaluationException {
        SimpleLogging.setFormatter(FORMATTER_INSTANTIATOR.evaluateTo(spec, Mappings.none(), Formatter.class));
    }

    public static void setFormatter(Formatter formatter) {
        DEBUG_HANDLER.setFormatter(formatter);
        OUT_HANDLER.setFormatter(formatter);
        STDERR_HANDLER.setFormatter(formatter);
    }

    public static void setNoWarn() {
        SimpleLogging.setLevel(LogUtil.WARNING_PLUS_1);
    }

    public static void setQuiet() {
        SimpleLogging.setLevel(LogUtil.INFO_PLUS_1);
    }

    public static void setNormal() {
        SimpleLogging.setLevel(Level.INFO);
    }

    public static void setVerbose() {
        SimpleLogging.setLevel(Level.CONFIG);
    }

    public static void setDebug() {
        Level l = SimpleLogging.getLevel();
        SimpleLogging.setLevel(l == Level.FINER ? Level.FINEST : (l == Level.FINE ? Level.FINER : Level.FINE));
    }

    public static void setStdout() {
        SimpleLogging.setOut(new StdoutHandler());
    }

    public static void setOut(File value) throws IOException {
        SimpleLogging.setOut(new FileHandler(value.getPath()));
    }

    public static synchronized void setOut(@Nullable Handler handler) {
        OUT_HANDLER.close();
        OUT_HANDLER.setDelegate(handler == null ? new StdoutHandler() : handler);
        OUT_HANDLER.setFilter(LogUtil.LESS_THAN_WARNING);
        OUT_HANDLER.setLevel(Level.INFO);
        OUT_HANDLER.setFormatter(DEFAULT_OUT_FORMATTER);
    }

    public static void configureLoggers(String spec) {
        Logger logger;
        int n;
        int n2;
        Logger[] loggerArray;
        Formatter formatter;
        Logger[] loggers;
        String[] args = new String[5];
        String[] sa = spec.split(":", 5);
        int i = 0;
        while (i < args.length && i < sa.length) {
            String s = sa[i].trim();
            if (!"".equals(s)) {
                args[i] = s;
            }
            ++i;
        }
        Level level = args[0] != null ? Level.parse(args[0]) : null;
        if (args[1] != null) {
            String loggerNames = args[1];
            String[] tmp = loggerNames.split(",");
            loggers = new Logger[tmp.length];
            int i2 = 0;
            while (i2 < tmp.length) {
                loggers[i2] = Logger.getLogger(tmp[i2]);
                ++i2;
            }
        } else {
            loggers = new Logger[]{LogUtil.ROOT_LOGGER};
        }
        Handler handler = null;
        if (args[2] != null) {
            String handlerSpec = args[2];
            try {
                handler = HANDLER_INSTANTIATOR.evaluateTo(handlerSpec, Mappings.none(), Handler.class);
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap(String.valueOf(handlerSpec) + ": " + e.getMessage(), e, RuntimeException.class);
            }
        }
        if (args[3] != null) {
            String formatterSpec = args[3];
            try {
                formatter = FORMATTER_INSTANTIATOR.evaluateTo(formatterSpec, Mappings.none(), Formatter.class);
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap("Evaluating formatter spec \"" + formatterSpec + "\": " + e.getMessage(), e, RuntimeException.class);
            }
        } else {
            formatter = PrintfFormatter.MESSAGE_AND_EXCEPTION;
        }
        boolean useParentHandlers = true;
        if (args[4] != null) {
            useParentHandlers = Boolean.parseBoolean(args[4]);
        }
        if (handler == null) {
            loggerArray = loggers;
            n2 = loggers.length;
            n = 0;
            while (n < n2) {
                logger = loggerArray[n];
                logger.setLevel(level);
                ++n;
            }
            handler = new StdoutHandler();
        }
        if (level != null) {
            handler.setLevel(level);
        }
        handler.setFormatter(formatter);
        loggerArray = loggers;
        n2 = loggers.length;
        n = 0;
        while (n < n2) {
            logger = loggerArray[n];
            logger.addHandler(handler);
            if (level == null || !logger.isLoggable(level)) {
                logger.setLevel(level);
            }
            logger.setUseParentHandlers(useParentHandlers);
            ++n;
        }
    }
}

