/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.time;

import de.unkrig.commons.util.time.Duration;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class PointOfTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long ms;

    public PointOfTime() {
        this.ms = System.currentTimeMillis();
    }

    public PointOfTime(String s) throws ParseException {
        this.ms = PointOfTime.parse(s);
    }

    public PointOfTime(long ms) {
        this.ms = ms;
    }

    public long milliseconds() {
        return this.ms;
    }

    public String toString() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(this.ms);
    }

    public PointOfTime add(double seconds) {
        return new PointOfTime(this.ms + (long)(1000.0 * seconds));
    }

    public PointOfTime add(Duration duration) {
        return new PointOfTime(this.ms + duration.milliseconds());
    }

    public Duration subtract(PointOfTime other) {
        return new Duration(this.ms - other.ms);
    }

    private static long parse(String s) throws ParseException {
        try {
            return DateFormat.getInstance().parse(s).getTime();
        }
        catch (ParseException parseException) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(s).getTime();
            }
            catch (ParseException parseException2) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").parse(s).getTime();
                }
                catch (ParseException parseException3) {
                    try {
                        return new SimpleDateFormat("yyyy-MM-dd").parse(s).getTime();
                    }
                    catch (ParseException parseException4) {
                        throw new ParseException("Cannot parse '" + s + "' to a valid date and/or time", 0);
                    }
                }
            }
        }
    }
}

