/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import com.agimatec.utility.fileimport.LineTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FixedLengthStringTokenizer
implements LineTokenizer<String, String> {
    private List myStringList = new ArrayList();
    private Iterator<String> myStringListIterator = null;

    public FixedLengthStringTokenizer(String aString, int[] fixedLengths) {
        if (aString == null || "".equals(aString)) {
            throw new IllegalArgumentException("String must not be null or empty!");
        }
        if (fixedLengths == null || fixedLengths.length == 0) {
            throw new IllegalArgumentException("fixedLengths must not be null or empty!");
        }
        if (this.makeMyStringList(aString, fixedLengths)) {
            this.myStringListIterator = this.myStringList.iterator();
        }
    }

    private boolean makeMyStringList(String aString, int[] lengths) {
        int positionString = 0;
        for (int length : lengths) {
            int absLength = Math.abs(length);
            if (positionString + absLength > aString.length()) {
                throw new IllegalArgumentException("The cumulated length is longer than the length of the row!");
            }
            if (length > 0) {
                String aktToken = aString.substring(positionString, positionString + length);
                this.myStringList.add(aktToken.trim());
            }
            positionString += absLength;
        }
        return true;
    }

    @Override
    public boolean hasMoreElements() {
        return this.myStringListIterator.hasNext();
    }

    @Override
    public String nextElement() {
        return this.myStringListIterator.next();
    }

    @Override
    public boolean isLineIncomplete() {
        return false;
    }

    @Override
    public String continueParse(String aSingleValue, String aRecord) {
        throw new UnsupportedOperationException();
    }
}

