/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import com.agimatec.utility.fileimport.Importer;
import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.ImporterProcessor;
import com.agimatec.utility.fileimport.LineImporterSpec;
import com.agimatec.utility.fileimport.LineReader;
import com.agimatec.utility.fileimport.LineTokenizer;
import com.agimatec.utility.fileimport.spreadsheet.ICell;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class LineImportProcessor
extends ImporterProcessor {
    protected final LineImporterSpec spec;
    protected LineReader lineReader;
    protected Object headerLine;
    protected Object currentLine;
    protected Map currentRow;

    public LineImportProcessor(LineImporterSpec spec, Importer importer) {
        super(importer);
        this.spec = spec;
    }

    public LineImporterSpec getSpec() {
        return this.spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFrom(Closeable aReader) throws ImporterException {
        super.importFrom(aReader);
        try {
            this.lineReader = this.spec.createLineReader(aReader);
            try {
                if (this.spec.getHeaderSpec() == LineImporterSpec.Header.FIRST) {
                    this.headerLine = this.lineReader.readLine();
                    this.spec.processHeaderLine(this);
                }
                this.currentLine = this.lineReader.readLine();
                while (this.currentLine != null && !this.isCancelled()) {
                    ++this.rowCount;
                    if (this.spec.getHeaderSpec() == LineImporterSpec.Header.INDEX && this.spec.getHeaderLineIndex() == this.rowCount) {
                        this.headerLine = this.currentLine;
                        this.spec.processHeaderLine(this);
                    } else {
                        this.importRow(this.currentLine);
                    }
                    this.currentLine = this.lineReader.readLine();
                }
            }
            finally {
                this.lineReader.close();
                this.release();
                this.logFinished();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void importRow(Object aLine) throws ImporterException {
        try {
            this.transferRow(aLine);
            this.spec.processRow(this);
        }
        catch (ImporterException ex) {
            this.handleRowException(ex, aLine);
            if (ex.isCancelImport()) {
                throw ex;
            }
        }
        catch (Exception ex) {
            this.handleRowException(ex, aLine);
        }
    }

    public void release() {
        super.release();
        this.currentRow = null;
        this.headerLine = null;
    }

    protected Map transferRow(Object aRecord) throws IOException {
        this.currentRow = new HashMap();
        LineTokenizer parser = this.spec.getLineTokenizerFactory().createTokenizer(aRecord);
        int fieldIdx = -1;
        while (parser.hasMoreElements()) {
            Object singleValue = parser.nextElement();
            if (parser.isLineIncomplete()) {
                do {
                    if ((aRecord = this.lineReader.readLine()) == null) continue;
                    singleValue = parser.continueParse(singleValue, aRecord);
                } while (parser.isLineIncomplete() && aRecord != null);
            }
            fieldIdx = singleValue instanceof ICell ? ((ICell)singleValue).getColumnIndex() : ++fieldIdx;
            this.setFieldValue(fieldIdx, singleValue);
        }
        return this.currentRow;
    }

    protected void setFieldValue(int fieldIdx, Object singleValue) {
        this.currentRow.put(this.spec.getFieldName(fieldIdx), singleValue);
    }

    protected Object getHeaderLine() {
        return this.headerLine;
    }

    public Map getCurrentRow() {
        return this.currentRow;
    }

    public LineReader getLineReader() {
        return this.lineReader;
    }

    public Object getCurrentLine() {
        return this.currentLine;
    }
}

