/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config;

import com.agimatec.commons.config.ConfigManager;
import com.agimatec.commons.config.Node;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNode
extends Node {
    private static final Logger log = LoggerFactory.getLogger(FileNode.class);
    protected String dir;
    protected String file;
    protected boolean relative = true;
    protected ConfigManager myConfigManager;

    public FileNode(ConfigManager theConfigManager) {
        this.myConfigManager = theConfigManager;
    }

    public Object getObjectValue() {
        return this.getFile();
    }

    public void setRelative(boolean aRelative) {
        this.relative = aRelative;
    }

    public boolean getRelative() {
        return this.relative;
    }

    public String getConfigRootPath() {
        if (log.isDebugEnabled() && this.myConfigManager == null) {
            log.debug("FileNode: No ConfigManager, using default");
        }
        return this.myConfigManager == null ? ConfigManager.getDefault().getConfigRootPath() : this.myConfigManager.getConfigRootPath();
    }

    public String getURLPath() {
        StringBuilder path = new StringBuilder();
        if (this.getRelative()) {
            path.append(this.getConfigRootPath());
        }
        if (this.getDir() != null) {
            path.append(this.getDir());
            char lastChar = this.getDir().charAt(this.getDir().length() - 1);
            if (lastChar != '/' && lastChar != '\\' && lastChar != ':') {
                path.append('/');
            }
        }
        path.append(this.getFileName());
        return path.toString();
    }

    public String getFilePath() {
        String p = this.getURLPath();
        if (p.toLowerCase().startsWith("file:")) {
            return p.substring(5);
        }
        return p;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String value) {
        this.dir = value;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String value) {
        this.file = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContentString() throws IOException {
        FileReader fr = new FileReader(this.getURLPath());
        try {
            int read;
            char[] cbuf = new char[4096];
            StringBuilder strbuf = new StringBuilder(256);
            while ((read = fr.read(cbuf)) > -1) {
                strbuf.append(cbuf, 0, read);
            }
            String string = strbuf.toString();
            return string;
        }
        finally {
            fr.close();
        }
    }

    public String getFileName() {
        if (this.getFile() != null) {
            return this.getFile();
        }
        return this.getName() + ".xml";
    }
}

