/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.DoubleNode;
import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.NodeHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DoubleNodeHandler
extends NodeHandler {
    public DoubleNodeHandler(String aTag) {
        super(aTag);
    }

    protected Class getInstanceClass() {
        return DoubleNode.class;
    }

    protected Object startNode(Attributes attr) throws SAXException {
        DoubleNode node = new DoubleNode();
        this.setName(node, attr);
        String value = this.getValue(attr);
        if (value != null) {
            this.setValue(node, value);
        }
        return node;
    }

    protected void acceptCharacters(ConfigContentHandler docHandler, char[] chars, int offset, int length) throws SAXException {
        DoubleNode node = (DoubleNode)docHandler.getCurrentNode();
        this.setValue(node, new String(chars, offset, length));
    }

    private void setValue(DoubleNode node, String stringValue) throws SAXException {
        try {
            node.setValue(Double.parseDouble(stringValue));
        }
        catch (NumberFormatException ex) {
            throw new SAXException("not a double: " + stringValue, ex);
        }
    }
}

