/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.IntNode;
import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.NodeHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class IntNodeHandler
extends NodeHandler {
    public IntNodeHandler(String aTag) {
        super(aTag);
    }

    protected Class getInstanceClass() {
        return IntNode.class;
    }

    protected Object startNode(Attributes attr) throws SAXException {
        IntNode node = new IntNode();
        this.setName(node, attr);
        String value = this.getValue(attr);
        if (value != null) {
            this.setValue(node, value);
        }
        return node;
    }

    protected void acceptCharacters(ConfigContentHandler docHandler, char[] chars, int offset, int length) throws SAXException {
        IntNode node = (IntNode)docHandler.getCurrentNode();
        this.setValue(node, new String(chars, offset, length));
    }

    private void setValue(IntNode node, String stringValue) throws SAXException {
        try {
            node.setValue(Integer.parseInt(stringValue));
        }
        catch (NumberFormatException ex) {
            throw new SAXException("not an int: " + stringValue, ex);
        }
    }
}

