/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.ListNode;
import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.ConfigWriter;
import com.agimatec.commons.config.sax.NodeHandler;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ListNodeHandler
extends NodeHandler {
    public ListNodeHandler(String aTag) {
        super(aTag);
    }

    protected Class getInstanceClass() {
        return ListNode.class;
    }

    protected Object startNode(Attributes attr) throws SAXException {
        ListNode node = new ListNode();
        this.setName(node, attr);
        return node;
    }

    protected void acceptNode(ConfigContentHandler docHandler, Object aNode, Attributes attr) throws SAXException {
        ((ListNode)docHandler.getCurrentNode()).getList().add(aNode);
    }

    protected void writeConfig(ConfigWriter writer, Object obj, Object parent, PrintWriter pw, int indent) throws SAXException {
        ListNode node = (ListNode)obj;
        pw.write(60);
        pw.write(this.tag());
        if (node.getName() != null) {
            pw.write(" name=\"");
            pw.write(StringEscapeUtils.escapeXml((String)node.getName()));
            pw.write("\"");
        }
        pw.write(62);
        Iterator iter = node.getList().iterator();
        ++indent;
        while (iter.hasNext()) {
            Object each = iter.next();
            pw.write(10);
            this.printIndent(pw, indent);
            writer.writeNode(each, pw, indent, node);
        }
        pw.write(10);
        this.printIndent(pw, indent - 1);
        pw.write("</");
        pw.write(this.tag());
        pw.write(62);
    }
}

