/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.jdbc;

import com.agimatec.commons.config.ConfigManager;
import com.agimatec.jdbc.JdbcException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class JdbcConfig {
    private final Properties properties = new Properties();
    static final String JDBC_URL = "jdbcUrl";
    static final String JDBC_DRIVER = "jdbcDriver";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String aURL) {
        try {
            InputStream in = ConfigManager.toURL(aURL).openStream();
            try {
                this.properties.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new JdbcException(e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getConnect() {
        return this.properties.getProperty(JDBC_URL);
    }

    public void setConnect(String urlConnect) {
        this.properties.setProperty(JDBC_URL, urlConnect);
    }

    public String getDriver() {
        return this.properties.getProperty(JDBC_DRIVER);
    }

    public void setDriver(String dr) {
        this.properties.setProperty(JDBC_DRIVER, dr);
    }
}

