/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql;

import com.agimatec.sql.SQLStringGenerator;
import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

final class SQLStmtPreparer
extends SQLStringGenerator {
    private final DateFormat SQLDateFormat = new SimpleDateFormat("yyyyMMdd");
    private final DateFormat SQLTimestampFormat;
    private final DateFormat SQLTimeFormat;
    private List newParams;

    SQLStmtPreparer(String input, Writer output, List params) {
        super(input, output, params);
        this.SQLDateFormat.setLenient(false);
        this.SQLTimestampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        this.SQLTimestampFormat.setLenient(false);
        this.SQLTimeFormat = new SimpleDateFormat("HHmmss");
        this.SQLTimeFormat.setLenient(false);
        this.newParams = new ArrayList(params.size());
    }

    public List getNewParams() {
        return this.newParams;
    }

    protected void handleParam(Object aValue) throws IOException {
        if (aValue instanceof Date) {
            this.addParseExpression("to_date(?, 'YYYYMMDD')");
            this.newParams.add(this.SQLDateFormat.format((Date)aValue));
        } else if (aValue instanceof Timestamp) {
            this.addParseExpression("to_date(?, 'YYYYMMDDHH24MISS')");
            this.newParams.add(this.SQLTimestampFormat.format((Timestamp)aValue));
        } else if (aValue instanceof Time) {
            this.addParseExpression("to_date(?, 'HH24MISS')");
            this.newParams.add(this.SQLTimeFormat.format((Time)aValue));
        } else if (aValue instanceof Collection) {
            Iterator iter = ((Collection)aValue).iterator();
            while (iter.hasNext()) {
                this.handleParam(iter.next());
                if (!iter.hasNext()) continue;
                this.addParseExpression(",");
            }
        } else {
            this.addParseExpression("?");
            this.newParams.add(aValue);
        }
    }
}

