/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.oracle;

import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.query.JdbcResultBuilder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class ForeignKeyDescriptionBuilder
implements JdbcResultBuilder {
    private static final int C_CONSTRAINT = 1;
    private static final int C_TABLE = 2;
    private static final int C_REF_TABLE = 3;
    private static final int C_COLUMN = 4;
    private static final int C_REF_COLUMN = 5;
    private List myFKs;
    private ForeignKeyDescription fk;

    public void afterExecute(ResultSetMetaData data, Object queryObject, List resultList) throws SQLException {
        this.myFKs = resultList;
    }

    public void fetch(ResultSet row) throws SQLException {
        String consName = row.getString(1);
        if (this.fk == null || !this.fk.getConstraintName().equals(consName)) {
            if (this.fk != null) {
                this.addFK();
            }
            this.fk = new ForeignKeyDescription();
            this.fk.setConstraintName(consName);
            this.fk.setTableName(row.getString(2));
            this.fk.setRefTableName(row.getString(3));
        }
        this.fk.addColumnPair(row.getString(4), row.getString(5));
    }

    public void close(boolean isComplete) throws SQLException {
        if (this.fk != null) {
            this.addFK();
        }
    }

    private void addFK() {
        this.myFKs.add(this.fk);
    }
}

