/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.oracle;

import com.agimatec.sql.meta.SequenceDescription;
import com.agimatec.sql.query.JdbcResultBuilder;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class SequenceDescriptionBuilder
implements JdbcResultBuilder {
    private static final int C_SEQUENCE_NAME = 1;
    private static final int C_MIN_VALUE = 2;
    private static final int C_MAX_VALUE = 3;
    private static final int C_INCREMENT_BY = 4;
    private static final int C_CYCLE_FLAG = 5;
    private static final int C_ORDER_FLAG = 6;
    private static final int C_CACHE_SIZE = 7;
    private static final String NOMAX_VALUE = "999999999999999999999999999";
    private List sequences;

    public void afterExecute(ResultSetMetaData data, Object queryObject, List resultList) throws SQLException {
        this.sequences = resultList;
    }

    public void fetch(ResultSet row) throws SQLException {
        SequenceDescription sequence = new SequenceDescription();
        sequence.setSequenceName(row.getString(1));
        String number = row.getString(3);
        if (row.wasNull() || NOMAX_VALUE.equals(number)) {
            sequence.setNoMaxValue();
        } else {
            sequence.setMaxValue(new BigDecimal(number));
        }
        number = row.getString(2);
        if (row.wasNull() || NOMAX_VALUE.equals("1")) {
            sequence.setNoMinValue();
        } else {
            sequence.setMinValue(new BigDecimal(number));
        }
        sequence.setIncrement(row.getInt(4));
        sequence.setCache(row.getInt(7));
        if (sequence.getCache() == 0) {
            sequence.setNoCache();
        }
        sequence.setCycle("Y".equals(row.getString(5)));
        sequence.setOrder("Y".equals(row.getString(6)));
        this.sequences.add(sequence);
    }

    public void close(boolean isComplete) throws SQLException {
    }
}

