/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.script;

import com.agimatec.commons.config.Config;
import com.agimatec.commons.config.ConfigManager;
import com.agimatec.commons.config.TextNode;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.mysql.MySqlDDLExpressions;
import com.agimatec.sql.meta.oracle.OracleDDLExpressions;
import com.agimatec.sql.meta.postgres.PostgresDDLExpressions;
import com.agimatec.sql.meta.script.DDLScriptSqlMetaFactory;
import com.agimatec.sql.meta.script.ExtractExpr;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DDLExpressions {
    public abstract ExtractExpr[] getExpressions();

    public static DDLExpressions forDbms(String dbms) {
        if ("oracle".equalsIgnoreCase(dbms)) {
            return new OracleDDLExpressions();
        }
        if ("postgres".equalsIgnoreCase(dbms)) {
            return new PostgresDDLExpressions();
        }
        if ("mysql".equalsIgnoreCase(dbms)) {
            return new MySqlDDLExpressions();
        }
        return null;
    }

    protected DDLExpressions() {
    }

    public ExtractExpr getExpression(String expName) {
        for (ExtractExpr each : this.getExpressions()) {
            if (!expName.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    public abstract void equalizeColumn(ColumnDescription var1);

    public String toString() {
        return this.getClass().getName();
    }

    public String strip(String value) {
        if (value == null) {
            return null;
        }
        int start = 0;
        int end = value.length();
        if (value.startsWith("\"")) {
            ++start;
        }
        if (value.endsWith("\"")) {
            --end;
        }
        return value.substring(start, end);
    }

    public static ExtractExpr[] compileExpressions(String ddlXmlPath) {
        Config cfg = ConfigManager.createForClasspath().readConfig(ddlXmlPath);
        return DDLScriptSqlMetaFactory.compileExpressions(DDLExpressions.convertToArray(cfg.getList("ddl")));
    }

    private static String[] convertToArray(List<TextNode> texts) {
        String[] stmtFormats = new String[texts.size()];
        int i = 0;
        for (TextNode each : texts) {
            stmtFormats[i++] = each.getValue().trim().replace("\n", "");
        }
        return stmtFormats;
    }
}

