/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.query;

import com.agimatec.sql.SQLStatement;
import com.agimatec.sql.query.QueryDefinition;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class SQLBuilder {
    private final Properties querySpecs = new Properties();

    public SQLBuilder(String resourceName) throws IOException {
        this.querySpecs.load(this.getClass().getClassLoader().getResourceAsStream(resourceName));
    }

    public String getResultBuilderName(String queryName) {
        return this.querySpecs.getProperty(queryName + ".resultbuilder");
    }

    public String getSQL(String queryName) {
        return this.querySpecs.getProperty(queryName + ".sql");
    }

    public SQLStatement generateSQL(QueryDefinition queryDefinition) {
        String sql = this.getSQL(queryDefinition.getQueryName());
        SQLStatement stmt = new SQLStatement(sql);
        int params = StringUtils.countMatches((String)sql, (String)"?");
        if (queryDefinition.getQueryObject() instanceof List) {
            List paramValues = (List)queryDefinition.getQueryObject();
            for (int i = 0; i < params; ++i) {
                stmt.addParameter(paramValues.get(i));
            }
        } else {
            for (int i = 0; i < params; ++i) {
                stmt.addParameter(queryDefinition.getQueryObject());
            }
        }
        return stmt;
    }
}

