/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.script;

import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.jdbc.JdbcException;
import com.agimatec.sql.script.ScriptVisitor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLScriptExecutor
implements ScriptVisitor {
    private static final Logger myLogger = LoggerFactory.getLogger(SQLScriptExecutor.class);
    protected static final Logger mySQLLogger = LoggerFactory.getLogger((String)"commons.sql");
    private JdbcDatabase store;

    public SQLScriptExecutor(JdbcDatabase aStore) {
        this.store = aStore;
    }

    protected Connection getConnection() {
        return this.store.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int visitStatement(String statement) throws SQLException {
        mySQLLogger.info(statement);
        if (this.getConnection() == null) {
            throw new JdbcException("cannot exec: " + statement + ", because 'not connected to database'");
        }
        Statement stmt = this.getConnection().createStatement();
        try {
            int n = stmt.executeUpdate(statement);
            return n;
        }
        finally {
            stmt.close();
        }
    }

    public void visitComment(String theComment) {
        this.log("Comment: " + theComment);
    }

    public void doCommit() throws SQLException {
        mySQLLogger.info("commit");
        if (this.getConnection() == null) {
            throw new JdbcException("cannot commit, because 'not connected to database'");
        }
        this.store.commit();
    }

    public void doRollback() throws SQLException {
        mySQLLogger.info("rollback");
        if (this.getConnection() == null) {
            throw new JdbcException("cannot rollback, because 'not connected to database'");
        }
        this.store.rollback();
    }

    public void log(Object obj) {
        if (obj instanceof Throwable) {
            myLogger.error(null, (Throwable)obj);
        } else {
            myLogger.info(String.valueOf(obj));
        }
    }
}

