/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.script;

import java.io.IOException;
import java.io.Reader;

public final class WordTokenizer {
    private boolean returnTokens;
    private boolean caseSensitive;
    private String[] separators;
    private final Reader myInput;
    private StringBuilder current;

    public WordTokenizer(Reader input, String[] separatorTokens, boolean returnSeparators, boolean aCaseSensitive) {
        this.myInput = input;
        this.separators = separatorTokens;
        this.returnTokens = returnSeparators;
        this.caseSensitive = aCaseSensitive;
    }

    public WordTokenizer(WordTokenizer parent, String[] separatorTokens, boolean returnSeparators, boolean aCaseSensitive) {
        this.myInput = parent.getReader();
        this.separators = separatorTokens;
        this.returnTokens = returnSeparators;
        this.caseSensitive = aCaseSensitive;
        this.current = parent.current;
    }

    public WordTokenizer(Reader input, String[] separatorTokens, boolean returnSeparators) {
        this(input, separatorTokens, returnSeparators, true);
    }

    public void continueFrom(WordTokenizer child) {
        this.current = child.current;
    }

    public WordTokenizer(Reader input, String[] separatorTokens) {
        this(input, separatorTokens, false, true);
    }

    public void setSeparators(String[] aSeparators) {
        this.separators = aSeparators;
    }

    public void setCaseSensitive(boolean aCaseSensitive) {
        this.caseSensitive = aCaseSensitive;
    }

    public void setReturnTokens(boolean aReturnTokens) {
        this.returnTokens = aReturnTokens;
    }

    public String nextToken() throws IOException {
        Object next;
        while ((next = this.nextObject()) == this) {
        }
        return (String)next;
    }

    private Object nextObject() throws IOException {
        String token = this.findToken();
        if (token != null) {
            return this.popCurrent(token);
        }
        int next = this.readNext();
        if (next != -1) {
            this.addChar(next);
            while ((token = this.findToken()) == null && next != -1) {
                next = this.readNext();
                this.addChar(next);
            }
        }
        return this.popCurrent(token);
    }

    protected int nextChar() throws IOException {
        if (this.current.length() > 0) {
            char r = this.current.charAt(0);
            this.current = new StringBuilder(this.current.substring(1));
            return r;
        }
        return this.readNext();
    }

    protected int readNext() throws IOException {
        return this.myInput.read();
    }

    public Reader getReader() {
        return this.myInput;
    }

    private String findToken() {
        String token = this.findPossibleToken();
        if (token != null) {
            String str = this.current.substring(this.current.length() - token.length() - 1);
            for (String each : this.separators) {
                if (!this.startsWith(each, str)) continue;
                return null;
            }
            return token;
        }
        return null;
    }

    private String findPossibleToken() {
        if (this.current == null || this.current.length() == 0) {
            return null;
        }
        String str = this.current.substring(0, this.current.length() - 1);
        if (str.length() == 0) {
            return null;
        }
        for (String each : this.separators) {
            if (!this.endsWith(str, each)) continue;
            return each;
        }
        return null;
    }

    private String endsWithToken() {
        if (this.current == null) {
            return null;
        }
        String str = this.current.toString();
        if (str.length() == 0) {
            return null;
        }
        for (String each : this.separators) {
            if (!this.endsWith(str, each)) continue;
            return each;
        }
        return null;
    }

    protected void addChar(int next) {
        if (next != -1) {
            if (this.current == null) {
                this.current = new StringBuilder();
            }
            this.current.append((char)next);
        }
    }

    public boolean isSeparator(String token) {
        for (String each : this.separators) {
            if (!this.equals(token, each)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(String s1, String s2) {
        return this.caseSensitive && s1.equals(s2) || !this.caseSensitive && s1.equalsIgnoreCase(s2);
    }

    private boolean endsWith(String s1, String s2) {
        return this.caseSensitive && s1.endsWith(s2) || !this.caseSensitive && s1.toLowerCase().endsWith(s2.toLowerCase());
    }

    private boolean startsWith(String s1, String s2) {
        return this.caseSensitive && s1.startsWith(s2) || !this.caseSensitive && s1.toLowerCase().startsWith(s2.toLowerCase());
    }

    private int indexOf(String str, String token) {
        return this.caseSensitive ? str.indexOf(token) : str.toLowerCase().indexOf(token.toLowerCase());
    }

    private Object popCurrent(String token) {
        if (this.current == null) {
            return null;
        }
        String str = this.current.toString();
        if (token != null) {
            if (this.equals(str, token)) {
                this.current = null;
                if (this.returnTokens) {
                    return str;
                }
                return this;
            }
            int idx = this.indexOf(str, token);
            if (idx > 0) {
                this.current = new StringBuilder(str.substring(idx));
                return str.substring(0, idx);
            }
            idx = token.length();
            this.current = new StringBuilder(str.substring(idx));
            if (this.returnTokens) {
                return str.substring(0, idx);
            }
            return this;
        }
        token = this.endsWithToken();
        if (token != null) {
            return this.popCurrent(token);
        }
        this.current = null;
        return str;
    }
}

