/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.secrets;

import de.vinado.boot.secrets.PropertyIndexSupplier;
import de.vinado.boot.secrets.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class FilenamePropertyIndexSupplier
implements PropertyIndexSupplier {
    public static final String BASE_DIR_PROPERTY = "secrets.file.base-dir";
    public static final String SEPARATOR_PROPERTY = "secrets.file.separator";
    public static final Separator DEFAULT_SEPARATOR = Separator.DOT;
    private static final String DEFAULT_BASE_DIR_PROPERTY = "/run/secrets";
    private final Log log;
    private final ConfigurableEnvironment environment;

    public FilenamePropertyIndexSupplier(DeferredLogFactory logFactory, ConfigurableEnvironment environment) {
        this.log = logFactory.getLog(this.getClass());
        this.environment = environment;
    }

    public Map<String, String> get() {
        String baseDir = this.environment.getProperty(BASE_DIR_PROPERTY, DEFAULT_BASE_DIR_PROPERTY);
        Separator separator = this.getSeparator();
        return Optional.of(baseDir).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(this::listFiles).orElse(Stream.empty()).filter(Utils.testAndLogFailure(this::isAllowed, arg_0 -> ((Log)this.log).warn(arg_0), (String)"Skipping ambiguous file %s, because of separator '%s'", (Function[])new Function[]{Path::toAbsolutePath, path -> separator})).collect(Collectors.toMap(this::convertToPropertyName, this::toUri));
    }

    private Separator getSeparator() {
        char property = ((Character)this.environment.getProperty(SEPARATOR_PROPERTY, Character.class, (Object)Character.valueOf(DEFAULT_SEPARATOR.getCharacter()))).charValue();
        return Separator.of(property);
    }

    private Stream<Path> listFiles(Path path) {
        try {
            return Files.list(path).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAllowed(Path path) {
        return this.isDefaultSeparator() || !this.containsDefaultSeparator(path);
    }

    private boolean isDefaultSeparator() {
        return Objects.equals((Object)this.getSeparator(), (Object)DEFAULT_SEPARATOR);
    }

    private boolean containsDefaultSeparator(Path path) {
        String name = this.getFilename(path);
        return name.lastIndexOf(DEFAULT_SEPARATOR.toString()) > 0;
    }

    private String convertToPropertyName(Path path) {
        Separator separator = this.getSeparator();
        String name = this.getFilename(path);
        String property = name.replace(separator.getCharacter(), '.');
        return property.toLowerCase(Locale.US);
    }

    private String getFilename(Path path) {
        File file = path.toFile();
        return file.getName();
    }

    private String toUri(Path path) {
        return path.toUri().toString();
    }

    public static enum Separator {
        DOT('.'),
        UNDERSCORE('_');

        private final char character;

        public static Separator of(char separator) {
            return Arrays.stream(Separator.values()).filter(value -> value.character == separator).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown separator char"));
        }

        public String toString() {
            return String.valueOf(this.character);
        }

        public char getCharacter() {
            return this.character;
        }

        private Separator(char character) {
            this.character = character;
        }
    }
}

