/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.secrets;

import de.vinado.boot.secrets.PropertyIndexSupplier;
import de.vinado.boot.secrets.Utils;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.Assert;

public class ConfigDataPropertyIndexSupplier
implements PropertyIndexSupplier {
    private static final String PROPERTY_PREFIX_TEMPLATE = "secrets.%s.properties";
    private final Log log;
    private final ConfigurableEnvironment environment;
    private final String prefix;

    public ConfigDataPropertyIndexSupplier(DeferredLogFactory logFactory, ConfigurableEnvironment environment, String propertyInfix) {
        Assert.notNull((Object)logFactory, (String)"Log factory must not be null");
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.hasText((String)propertyInfix, (String)"Property infix must not be null or empty");
        this.log = logFactory.getLog(this.getClass());
        this.environment = environment;
        this.prefix = String.format(PROPERTY_PREFIX_TEMPLATE, propertyInfix);
    }

    public Map<String, String> get() {
        MutablePropertySources sources = this.environment.getPropertySources();
        PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver((PropertySources)sources);
        return sources.stream().filter(MapPropertySource.class::isInstance).map(MapPropertySource.class::cast).map(PropertySource::getSource).map(Map::keySet).flatMap(Collection::stream).filter(Utils.startsWith((String)this.prefix)).filter(Utils.testAndLogFailure(this::isValid, arg_0 -> ((Log)this.log).warn(arg_0), (String)"Property [%s] is too short to assign.", (Function[])new Function[]{Function.identity()})).collect(Collectors.toMap(Utils.substring((int)(this.prefix.length() + 1)), arg_0 -> ((PropertySourcesPropertyResolver)resolver).getProperty(arg_0)));
    }

    private boolean isValid(String property) {
        return property.length() >= this.prefix.length() + 1;
    }
}

