/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.secrets;

import de.vinado.boot.secrets.PropertyIndexSupplier;
import de.vinado.boot.secrets.Utils;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EnvironmentPropertyIndexSupplier
implements PropertyIndexSupplier {
    private final ConfigurableEnvironment environment;
    private final String suffix;

    public EnvironmentPropertyIndexSupplier(DeferredLogFactory logFactory, ConfigurableEnvironment environment) {
        this(logFactory, environment, "");
    }

    public EnvironmentPropertyIndexSupplier(DeferredLogFactory logFactory, ConfigurableEnvironment environment, String suffix) {
        Assert.notNull((Object)logFactory, (String)"Log factory must not be null");
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.notNull((Object)suffix, (String)"Suffix must not be null");
        this.environment = environment;
        this.suffix = suffix;
        Log log = logFactory.getLog(this.getClass());
        Utils.testAndLogFailure(StringUtils::hasText, arg_0 -> ((Log)log).warn(arg_0), (String)"Suffix doesn't contain any characters. Thus all environment properties will be indexed which might be a security risk.", (Function[])new Function[0]).test(suffix);
    }

    public Map<String, String> get() {
        return this.environment.getSystemEnvironment().keySet().stream().filter(Utils.endsWith((String)this.suffix)).filter(entry -> StringUtils.hasText((String)this.environment.getProperty(entry))).collect(Collectors.toMap(this::convertToPropertyName, this.substitute((PropertyResolver)this.environment)));
    }

    private String convertToPropertyName(String propertyName) {
        String deSuffixed = propertyName.substring(0, propertyName.length() - this.suffix.length());
        String property = deSuffixed.replace("_", ".");
        return property.toLowerCase();
    }
}

