/*
 * Decompiled with CFR 0.152.
 */
package wcmiocaconfigextensions.io.wcm.wcm.commons.util;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.tenant.Tenant;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Path {
    private static final String VERSION_HISTORY_PATH = "/content/versionhistory";
    private static final String LAUNCHES_PATH = "/content/launches";
    private static final Pattern VERSION_HISTORY_PATTERN = Pattern.compile("/content/versionhistory/[^/]+(/.*)?");
    private static final Pattern VERSION_HISTORY_TENANT_PATTERN = Pattern.compile("/content/versionhistory/[^/]+/[^/]+(/.*)?");
    private static final Pattern LAUNCHES_PATTERN = Pattern.compile("/content/launches/\\d+/\\d+/\\d+/[^/]+(/.*)?");

    private Path() {
    }

    public static String getAbsoluteParent(String path, int parentLevel, ResourceResolver resourceResolver) {
        if (parentLevel < 0) {
            return "";
        }
        int level = parentLevel + Path.getParentLevelOffset(path, resourceResolver);
        return Text.getAbsoluteParent((String)path, (int)level);
    }

    public static Page getAbsoluteParent(Page page, int parentLevel, ResourceResolver resourceResolver) {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        String absoluteParentPath = Path.getAbsoluteParent(page.getPath(), parentLevel, resourceResolver);
        if (StringUtils.isEmpty((CharSequence)absoluteParentPath)) {
            return null;
        }
        return pageManager.getPage(absoluteParentPath);
    }

    public static int getAbsoluteLevel(String path, ResourceResolver resourceResolver) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.equals((CharSequence)path, (CharSequence)"/")) {
            return -1;
        }
        String originalPath = Path.getOriginalPath(path, resourceResolver);
        return StringUtils.countMatches((CharSequence)originalPath, (CharSequence)"/") - 1;
    }

    public static String getOriginalPath(String path, ResourceResolver resourceResolver) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        Matcher versionHistoryMatcher = Path.getVersionHistoryPattern(resourceResolver).matcher(path);
        if (versionHistoryMatcher.matches()) {
            return "/content" + versionHistoryMatcher.group(1);
        }
        Matcher launchesMatcher = LAUNCHES_PATTERN.matcher(path);
        if (launchesMatcher.matches()) {
            return launchesMatcher.group(1);
        }
        return path;
    }

    private static int getParentLevelOffset(String path, ResourceResolver resourceResolver) {
        Matcher versionHistoryMatcher = Path.getVersionHistoryPattern(resourceResolver).matcher(path);
        if (versionHistoryMatcher.matches()) {
            return Path.isTenant(resourceResolver) ? 3 : 2;
        }
        Matcher launchesMatcher = LAUNCHES_PATTERN.matcher(path);
        if (launchesMatcher.matches()) {
            return 6;
        }
        return 0;
    }

    private static boolean isTenant(ResourceResolver resourceResolver) {
        Tenant tenant = (Tenant)resourceResolver.adaptTo(Tenant.class);
        return tenant != null;
    }

    private static Pattern getVersionHistoryPattern(ResourceResolver resourceResolver) {
        if (Path.isTenant(resourceResolver)) {
            return VERSION_HISTORY_TENANT_PATTERN;
        }
        return VERSION_HISTORY_PATTERN;
    }
}

