/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass;

import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.UnsupportedContextException;
import io.bit3.jsass.adapter.NativeAdapter;
import io.bit3.jsass.context.Context;
import io.bit3.jsass.context.FileContext;
import io.bit3.jsass.context.ImportStack;
import io.bit3.jsass.context.StringContext;
import io.bit3.jsass.function.FunctionArgumentSignatureFactory;
import io.bit3.jsass.function.FunctionWrapperFactory;
import java.net.URI;
import java.util.Objects;

public class Compiler {
    private final NativeAdapter adapter;

    public Compiler() {
        FunctionArgumentSignatureFactory functionArgumentSignatureFactory = new FunctionArgumentSignatureFactory();
        FunctionWrapperFactory functionWrapperFactory = new FunctionWrapperFactory(functionArgumentSignatureFactory);
        this.adapter = new NativeAdapter(functionWrapperFactory);
    }

    public Output compileString(String string, Options options) throws CompilationException {
        return this.compileString(string, null, null, options);
    }

    public Output compileString(String string, URI inputPath, URI outputPath, Options options) throws CompilationException {
        StringContext context = new StringContext(string, inputPath, outputPath, options);
        return this.compile(context);
    }

    public Output compileFile(URI inputPath, URI outputPath, Options options) throws CompilationException {
        FileContext context = new FileContext(inputPath, outputPath, options);
        return this.compile(context);
    }

    public Output compile(Context context) throws CompilationException {
        Objects.requireNonNull(context, "Parameter context must not be null");
        if (context instanceof FileContext) {
            return this.compile((FileContext)context);
        }
        if (context instanceof StringContext) {
            return this.compile((StringContext)context);
        }
        throw new UnsupportedContextException(context);
    }

    public Output compile(StringContext context) throws CompilationException {
        ImportStack importStack = new ImportStack();
        return this.adapter.compile(context, importStack);
    }

    public Output compile(FileContext context) throws CompilationException {
        ImportStack importStack = new ImportStack();
        return this.adapter.compile(context, importStack);
    }
}

