/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.details;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import design.aem.components.ComponentProperties;
import design.aem.models.v2.details.GenericDetails;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.TagUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class EventDetails
extends GenericDetails {
    static final String EVENT_DISPLAY_DATE_FORMAT = "EEE d MMMMM";
    static final String EVENT_DISPLAY_DATE_FORMAT_ISO = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final String EVENT_TIME_DEFAULT_FORMAT = "h:mm a";
    static final String HOURS_TIME_FORMAT = "h a";
    static final String MINUTES_TIME_FORMAT = "mm";
    static final String TIME_ZERO_FORMAT = "00";
    static final String DEFAULT_FORMAT_TITLE = "${title}";
    static final String FIELD_FORMAT_TITLE = "titleFormat";
    static final String FIELD_FORMATTED_TITLE = "titleFormatted";
    static final String FIELD_FORMATTED_TITLE_TEXT = "titleFormattedText";
    static final String DEFAULT_FORMAT_SUBTITLE = "${eventStartDateText} to ${eventEndDateText}";
    static final String DEFAULT_FORMAT_DISPLAYDATE = "${eventStartDateText} to ${eventEndDateText}";
    static final String DEFAULT_FORMAT_DISPLAYTIME = "${eventStartTimeText} to ${eventEndTimeText}";
    static final String FIELD_EVENT_START_DATE = "eventStartDate";
    static final String FIELD_EVENT_END_DATE = "eventEndDate";

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_TITLE_TAG_TYPE = "h1";
        String DEFAULT_I18N_CATEGORY = "event-detail";
        String DEFAULT_I18N_LABEL = "variantHiddenLabel";
        String DEFAULT_TITLE = CommonUtil.getPageTitle(this.getResourcePage(), this.getResource());
        String DEFAULT_DESCRIPTION = this.getResourcePage().getDescription();
        Boolean DEFAULT_SHOW_BREADCRUMB = true;
        Boolean DEFAULT_SHOW_TOOLBAR = true;
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"title", DEFAULT_TITLE}, {"description", DEFAULT_DESCRIPTION}, {FIELD_EVENT_START_DATE, this.getResourcePage().getProperties().get("onTime", (Object)((Calendar)this.getResourcePage().getProperties().get("jcr:created", (Object)Calendar.getInstance())))}, {FIELD_EVENT_END_DATE, this.getResourcePage().getProperties().get("offTime", (Object)((Calendar)this.getResourcePage().getProperties().get("jcr:created", (Object)Calendar.getInstance())))}, {"eventLoc", ""}, {"eventRefLabel", ""}, {"eventRefLink", ""}, {"eventRefLabel2", ""}, {"eventRefLink2", ""}, {"useParentPageTitle", false}, {"showBreadcrumb", DEFAULT_SHOW_BREADCRUMB}, {"showToolbar", DEFAULT_SHOW_TOOLBAR}, {FIELD_FORMAT_TITLE, ""}, {"subTitleFormat", ""}, {"eventDisplayDateFormat", ""}, {"eventDisplayTimeFormat", ""}, {"eventTimeFormat", EVENT_TIME_DEFAULT_FORMAT}, {"cq:tags", new String[0]}, {"menuColor", ""}, {"showTags", false}, {"subCategory", ""}, {"pageUrl", CommonUtil.getPageUrl(this.getResourcePage())}, {"pageTitle", DEFAULT_TITLE}, {"pageNavTitle", CommonUtil.getPageNavTitle(this.getResourcePage())}, {"titleType", "h1"}, {"variantHiddenLabel", I18nUtil.getDefaultLabelIfEmpty("", "event-detail", "variantHiddenLabel", "event-detail", i18n, new String[0])}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS, ComponentsUtil.DEFAULT_FIELDS_DETAILS_OPTIONS});
        String[] tags = (String[])this.componentProperties.get("cq:tags", new String[0]);
        this.componentProperties.put("category", TagUtil.getTagsAsAdmin(this.getSlingScriptHelper(), tags, this.getRequest().getLocale()));
        this.componentProperties.putAll(this.processComponentFields(this.componentProperties, i18n, this.getSlingScriptHelper()), false);
        if (Boolean.TRUE.equals(this.componentProperties.get("isPastEventDate", false))) {
            this.componentProperties.put("cardAdditional", "finished");
        }
        this.processCommonFields();
    }

    @Override
    public Map<String, Object> processComponentFields(ComponentProperties componentProperties, I18n i18n, SlingScriptHelper sling) {
        HashMap<String, Object> newFields = new HashMap<String, Object>();
        String formattedTitle = ComponentsUtil.compileComponentMessage(FIELD_FORMAT_TITLE, DEFAULT_FORMAT_TITLE, componentProperties, sling);
        Document fragment = Jsoup.parse(formattedTitle);
        String formattedTitleText = fragment.text();
        newFields.put(FIELD_FORMATTED_TITLE, formattedTitle.trim());
        newFields.put(FIELD_FORMATTED_TITLE_TEXT, formattedTitleText.trim());
        Calendar eventStartDate = (Calendar)componentProperties.get(FIELD_EVENT_START_DATE, Calendar.getInstance());
        Calendar eventEndDate = (Calendar)componentProperties.get(FIELD_EVENT_END_DATE, Calendar.getInstance());
        String selectedEventTimeFormat = (String)componentProperties.get("eventTimeFormat", "");
        newFields.put("isPastEventDate", eventEndDate.before(Calendar.getInstance()));
        newFields.put(FIELD_EVENT_START_DATE, eventStartDate);
        newFields.put(FIELD_EVENT_END_DATE, eventEndDate);
        FastDateFormat dateFormatString = FastDateFormat.getInstance((String)EVENT_DISPLAY_DATE_FORMAT_ISO);
        Date startDateTime = eventStartDate.getTime();
        Date endDateTime = eventEndDate.getTime();
        newFields.put("eventStartDateISO", dateFormatString.format(startDateTime));
        newFields.put("eventEndDateISO", dateFormatString.format(endDateTime));
        FastDateFormat dateFormat = FastDateFormat.getInstance((String)EVENT_DISPLAY_DATE_FORMAT);
        String eventStartDateText = dateFormat.format(startDateTime);
        String eventEndDateText = dateFormat.format(endDateTime);
        String eventStartDateUppercase = dateFormat.format(startDateTime).toUpperCase();
        String eventEndDateUppercase = dateFormat.format(endDateTime).toUpperCase();
        String eventStartDateLowercase = dateFormat.format(startDateTime).toLowerCase();
        String eventEndDateLowercase = dateFormat.format(endDateTime).toLowerCase();
        newFields.put("eventStartDateText", eventStartDateText);
        newFields.put("eventEndDateText", eventEndDateText);
        newFields.put("eventStartDateUppercase", eventStartDateUppercase);
        newFields.put("eventEndDateUppercase", eventEndDateUppercase);
        newFields.put("eventStartDateLowercase", eventStartDateLowercase);
        newFields.put("eventEndDateLowercase", eventEndDateLowercase);
        if (!selectedEventTimeFormat.equals(EVENT_TIME_DEFAULT_FORMAT)) {
            selectedEventTimeFormat = TagUtil.getTagValueAsAdmin(selectedEventTimeFormat, sling);
        }
        FastDateFormat timeFormat = FastDateFormat.getInstance((String)selectedEventTimeFormat);
        FastDateFormat minTimeFormat = FastDateFormat.getInstance((String)MINUTES_TIME_FORMAT);
        FastDateFormat hourTimeFormat = FastDateFormat.getInstance((String)HOURS_TIME_FORMAT);
        String eventStartTimeText = timeFormat.format(startDateTime);
        String eventEndTimeText = timeFormat.format(endDateTime);
        String startTimeMinutes = minTimeFormat.format(startDateTime);
        String endTimeMinutes = minTimeFormat.format(endDateTime);
        String eventStartTimeMinFormatted = timeFormat.format(startDateTime).toLowerCase();
        String eventEndTimeMinFormatted = timeFormat.format(endDateTime).toLowerCase();
        if (startTimeMinutes.equals(TIME_ZERO_FORMAT)) {
            eventStartTimeMinFormatted = hourTimeFormat.format(startDateTime);
        }
        if (endTimeMinutes.equals(TIME_ZERO_FORMAT)) {
            eventEndTimeMinFormatted = hourTimeFormat.format(endDateTime);
        }
        newFields.put("eventStartTimeText", eventStartTimeText);
        newFields.put("eventEndTimeText", eventEndTimeText);
        newFields.put("eventStartTimeUppercase", eventStartTimeText.toUpperCase());
        newFields.put("eventEndTimeUppercase", eventEndTimeText.toUpperCase());
        newFields.put("eventStartTimeLowercase", eventStartTimeText.toLowerCase());
        newFields.put("eventEndTimeLowercase", eventEndTimeText.toLowerCase());
        newFields.put("eventStartTimeMinFormatted", eventStartTimeMinFormatted);
        newFields.put("eventEndTimeMinFormatted", eventEndTimeMinFormatted);
        newFields.put("eventStartTimeMinLowerFormatted", eventStartTimeMinFormatted.toLowerCase());
        newFields.put("eventEndTimeMinLowerFormatted", eventEndTimeMinFormatted.toLowerCase());
        newFields.put("eventStartTimeMinUpperFormatted", eventStartTimeMinFormatted.toUpperCase());
        newFields.put("eventEndTimeMinUpperFormatted", eventEndTimeMinFormatted.toUpperCase());
        componentProperties.putAll(newFields);
        newFields.put(FIELD_FORMATTED_TITLE, ComponentsUtil.compileComponentMessage(FIELD_FORMAT_TITLE, DEFAULT_FORMAT_TITLE, componentProperties, sling));
        newFields.put("subTitleFormatted", ComponentsUtil.compileComponentMessage("subTitleFormat", "${eventStartDateText} to ${eventEndDateText}", componentProperties, sling));
        newFields.put("eventDisplayDateFormatted", ComponentsUtil.compileComponentMessage("eventDisplayDateFormat", "${eventStartDateText} to ${eventEndDateText}", componentProperties, sling));
        newFields.put("eventDisplayTimeFormatted", ComponentsUtil.compileComponentMessage("eventDisplayTimeFormat", DEFAULT_FORMAT_DISPLAYTIME, componentProperties, sling));
        return newFields;
    }
}

