/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.details;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.google.common.base.Throwables;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.services.ContentAccess;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentDetailsUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.ContentFragmentUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.ImagesUtil;
import design.aem.utils.components.ResolverUtil;
import design.aem.utils.components.TagUtil;
import design.aem.utils.components.TenantUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDetails
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GenericDetails.class);
    private static final String COMPONENT_DETAILS_NAME = "generic-details";
    private static final String PAGE_META_PROPERTY_FIELDS = "metaPropertyFields";
    private static final String DEFAULT_FORMAT_TITLE = "${title}";
    private static final String FIELD_FORMAT_TITLE = "titleFormat";
    private static final String FIELD_FORMATTED_TITLE = "titleFormatted";
    private static final String FIELD_FORMATTED_TITLE_TEXT = "titleFormattedText";
    private static final String FIELD_SUBCATEGORY = "subCategory";
    private static final String FIELD_CATEGORY = "category";
    private static final String FIELD_LEGACY_BADGE_CONFIG = "legacyBadgeConfig";
    private static final String FIELD_LEGACY_BADGE_SELECTED = "legacyBadgeSelected";
    private static final String FIELD_LEGACY_BADGE = "legacyBadge";
    private static final String FIELD_LEGACY_BADGE_LIST = "legacyBadgeList";
    private static final String FIELD_LEGACY_BADGE_LIST_MAPPING = "legacyBadgeListMapping";
    private static final String FIELD_LEGACY_BADGE_CNNFIG_TAGS = "legacyBadgeConfigTags";
    private static final String DEFAULT_TAG_LEGACY_BADGE_CONFIG = ":component-dialog/components/details/generic-details/legacy";
    private static final String FIELD_CONTENTFRAGMENT_VARIATION = "variationName";
    private static final String FIELD_CONTENTFRAGMENT_FRAGMENTPATH = "fragmentPath";
    private static final String[] legacyBadgeList = new String[]{"badge.cardActionIconDescription", "badge.cardActionIconTitleCategoryDescription", "badge.cardActionIconTitleDescription", "badge.cardActionImageTitle", "badge.cardActionImageTitleCategoryDescription", "badge.cardActionImageTitleDescription", "badge.cardHorizontalIconTitleCategoryDescriptionAction", "badge.cardIcon", "badge.cardIconDescription", "badge.cardIconTitle", "badge.cardIconTitleAction", "badge.cardIconTitleCategoryDescription", "badge.cardIconTitleCategoryDescriptionAction", "badge.cardIconTitleDateAction", "badge.cardIconTitleDateDescriptionAction", "badge.cardIconTitleDescription", "badge.cardIconTitleDescriptionAction", "badge.cardIconTitleSubtitleDate", "badge.cardIconTitleSubtitleDateDescriptionAction", "badge.cardIconTitleSubtitleDescriptionAction", "badge.cardImageSubtitleTitleCategoryDescriptionAction", "badge.cardImageSubtitleTitleDescriptionAction", "badge.cardImageTagTitleAction", "badge.cardImageTitleAction", "badge.cardImageTitleCategoryActionDate", "badge.cardImageTitleCategoryDescription", "badge.cardImageTitleCategoryDescriptionAction", "badge.cardImageTitleDescription", "badge.cardImageTitleDescriptionAction", "badge.cardImageTitleSubtitleDescriptionAction", "badge.cardTitleDescriptionAction", "badge.data", "badge.default", "badge.icon", "badge.image", "badge.metadata"};
    private static final String[][] legacyBadgeListMapping = new String[][]{{"action-icon", "description"}, {"action-icon", "title", "taglist", "description"}, {"action-icon", "title", "description"}, {"action-image", "title"}, {"action-image", "title", "taglist", "description"}, {"action-image", "title", "description"}, {"horizontal-icon", "title", "taglist", "description", "action"}, {"card-icon"}, {"card-icon", "description"}, {"card-icon", "title"}, {"card-icon", "title", "action"}, {"card-icon", "title", "taglist", "description"}, {"card-icon", "title", "taglist", "description", "action"}, {"card-icon", "title", "startdate", "action"}, {"card-icon", "title", "startdate", "description"}, {"card-icon", "title", "description"}, {"card-icon", "title", "description", "action"}, {"card-icon", "title", "subtitle", "startdate"}, {"card-icon", "title", "subtitle", "startdate", "description", "action"}, {"card-icon", "title", "subtitle", "description", "action"}, {"card-image", "subtitle", "title", "taglist", "description", "action"}, {"card-image", "subtitle", "title", "description", "action"}, {"card-image", "taglist", "title", "action"}, {"card-image", "title", "action"}, {"card-image", "title", "taglist", "action", "startdate"}, {"card-image", "title", "taglist", "description"}, {"card-image", "title", "taglist", "description", "action"}, {"card-image", "title", "description"}, {"card-image", "title", "description", "action"}, {"card-image", "title", "subtitle", "description", "action"}, {"card", "title", "description", "action"}, {"simple-data"}, {"default"}, {"simple-icon"}, {"simple-image"}, {"simple-metadata"}};
    protected ComponentProperties componentProperties = null;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_ARIA_ROLE = "banner";
        String DEFAULT_TITLE_TAG_TYPE = "h1";
        String DEFAULT_I18N_CATEGORY = "page-detail";
        String DEFAULT_I18N_LABEL = "variantHiddenLabel";
        String DEFAULT_TITLE = CommonUtil.getPageTitle(this.getResourcePage(), this.getResource());
        String DEFAULT_DESCRIPTION = this.getResourcePage().getDescription();
        String DEFAULT_SUBTITLE = (String)this.getResourcePage().getProperties().get("subtitle", (Object)"");
        Boolean DEFAULT_HIDE_TITLE = false;
        Boolean DEFAULT_HIDE_DESCRIPTION = false;
        Boolean DEFAULT_SHOW_BREADCRUMB = true;
        Boolean DEFAULT_SHOW_TOOLBAR = true;
        Boolean DEFAULT_SHOW_PAGE_DATE = true;
        Boolean DEFAULT_SHOW_PARSYS = true;
        this.componentProperties = ComponentsUtil.getNewComponentProperties(this);
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"title", DEFAULT_TITLE}, {FIELD_FORMAT_TITLE, ""}, {"description", DEFAULT_DESCRIPTION}, {"hideDescription", DEFAULT_HIDE_DESCRIPTION}, {"hideTitle", DEFAULT_HIDE_TITLE}, {"showBreadcrumb", DEFAULT_SHOW_BREADCRUMB}, {"showToolbar", DEFAULT_SHOW_TOOLBAR}, {"showPageDate", DEFAULT_SHOW_PAGE_DATE}, {"showParsys", DEFAULT_SHOW_PARSYS}, {"linkTarget", "", "target"}, {"pageUrl", CommonUtil.getPageUrl(this.getResourcePage())}, {"pageTitle", DEFAULT_TITLE}, {"pageNavTitle", CommonUtil.getPageNavTitle(this.getResourcePage())}, {"subtitle", DEFAULT_SUBTITLE}, {"cq:tags", new String[0]}, {FIELD_SUBCATEGORY, new String[0]}, {"ariaRole", "banner", "role"}, {"titleType", "h1"}, {"variantHiddenLabel", I18nUtil.getDefaultLabelIfEmpty("", "page-detail", "variantHiddenLabel", "page-detail", i18n, new String[0])}, {FIELD_LEGACY_BADGE_LIST, legacyBadgeList}, {FIELD_LEGACY_BADGE_LIST_MAPPING, legacyBadgeListMapping}, {FIELD_LEGACY_BADGE_CNNFIG_TAGS, TenantUtil.resolveTenantIdFromPath(this.getCurrentPage().getPath()).concat(DEFAULT_TAG_LEGACY_BADGE_CONFIG)}, {"variantFields", new String[0]}, {"variantFieldsTemplate", new String[0]}, {FIELD_CONTENTFRAGMENT_VARIATION, "master"}, {FIELD_CONTENTFRAGMENT_FRAGMENTPATH, ""}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS, ComponentsUtil.DEFAULT_FIELDS_DETAILS_OPTIONS});
        String fragmentPath = (String)this.componentProperties.get(FIELD_CONTENTFRAGMENT_FRAGMENTPATH, "");
        String variationName = (String)this.componentProperties.get(FIELD_CONTENTFRAGMENT_VARIATION, "master");
        this.componentProperties.putAll(ContentFragmentUtil.getComponentFragmentMap(fragmentPath, variationName, this.getResourceResolver()));
        String[] tags = (String[])this.componentProperties.get("cq:tags", new String[0]);
        this.componentProperties.put(FIELD_CATEGORY, TagUtil.getTagsAsAdmin(this.getSlingScriptHelper(), tags, this.getRequest().getLocale()));
        String[] subCategory = (String[])this.componentProperties.get(FIELD_SUBCATEGORY, new String[0]);
        this.componentProperties.put(FIELD_SUBCATEGORY, TagUtil.getTagsAsAdmin(this.getSlingScriptHelper(), subCategory, this.getRequest().getLocale()));
        this.processCommonFields();
        this.componentProperties.putAll(this.processComponentFields(this.componentProperties, i18n, this.getSlingScriptHelper()), false);
    }

    protected void processCommonFields() {
        try {
            ContentAccess contentAccess;
            String badge;
            if (this.componentProperties == null) {
                this.componentProperties = ComponentsUtil.getNewComponentProperties(this);
            }
            this.componentProperties.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getPageImgReferencePath(this.getResourcePage()), "pageImage"));
            this.componentProperties.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getResourceImagePath(this.getResource(), "secondaryImage"), "pageSecondaryImage"));
            this.componentProperties.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getResourceImagePath(this.getResource(), "bgimage"), "pageBackgroundImage"));
            this.componentProperties.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getResourceImagePath(this.getResource(), "thumbnail"), "pageThumbnailImage"));
            this.componentProperties.put("redirectTarget", this.getResourcePage().getProperties().get("redirectTarget", (Object)""));
            this.componentProperties.put("pageImageThumbnail", ImagesUtil.getBestFitRendition((String)this.componentProperties.get("pageImage", ""), (Integer)this.componentProperties.get("badgeThumbnailWidth", 319), this.getResourceResolver()));
            this.componentProperties.put("pageSecondaryImageThumbnail", ImagesUtil.getBestFitRendition((String)this.componentProperties.get("pageSecondaryImage", ""), (Integer)this.componentProperties.get("badgeThumbnailWidth", 319), this.getResourceResolver()));
            this.componentProperties.put("pageThumbnailImageThumbnail", ImagesUtil.getBestFitRendition((String)this.componentProperties.get("pageThumbnailImage", ""), (Integer)this.componentProperties.get("badgeThumbnailWidth", 319), this.getResourceResolver()));
            String componentBadge = CommonUtil.getBadgeFromSelectors(this.getRequest().getRequestPathInfo().getSelectorString());
            Boolean badgeWasRequested = StringUtils.isNotEmpty((CharSequence)componentBadge);
            String requestedBadgeTemplate = MessageFormat.format("{0}.html", componentBadge);
            if (StringUtils.isEmpty((CharSequence)componentBadge)) {
                this.componentProperties.put("componentBadgeSelected", false);
                componentBadge = "default";
                requestedBadgeTemplate = MessageFormat.format("badge.{0}.html", componentBadge);
            } else {
                this.componentProperties.put("componentBadgeSelected", true);
            }
            String defaultBadgeTemplate = MessageFormat.format("badge.{0}.html", "default");
            String badgePath = ComponentsUtil.findLocalResourceInSuperComponent(this.getComponent(), requestedBadgeTemplate, this.getSlingScriptHelper());
            if (StringUtils.isEmpty((CharSequence)badgePath)) {
                if (Boolean.TRUE.equals(badgeWasRequested) && !ArrayUtils.contains((Object[])legacyBadgeList, (Object)componentBadge)) {
                    LOGGER.error("LEGACY BADGE WAS REQUESTED BUT NOT FOUND IN COMPONENT AND LEGACY MAPPING NOT FOUND requestedBadgeTemplate={}", (Object)requestedBadgeTemplate);
                }
                componentBadge = "default";
                requestedBadgeTemplate = defaultBadgeTemplate;
            }
            this.componentProperties.put("componentBadge", componentBadge);
            this.componentProperties.put("componentBadgeTemplate", requestedBadgeTemplate);
            this.componentProperties.put("bgimage", (Object)ImagesUtil.getBackgroundImageRenditions(this));
            ComponentProperties badgeOverrides = ComponentDetailsUtil.processBadgeRequestConfig(this.componentProperties, this.getResourceResolver(), (HttpServletRequest)this.getRequest());
            if (Boolean.FALSE.equals(badgeOverrides.get("badgeCustom", false))) {
                badgeOverrides.remove("badgeCustom");
                badgeOverrides.remove("badgeFields");
                badgeOverrides.remove("badgeFieldsTemplate");
                badgeOverrides.remove("badgeTemplate");
            }
            this.componentProperties.putAll((Map<? extends String, ?>)((Object)badgeOverrides), true);
            this.componentProperties.evaluateExpressionFields();
            this.componentProperties.putAll(GenericDetails.processBadgeConfig(this.getResourcePage(), this.componentProperties));
            if (Boolean.TRUE.equals(this.componentProperties.get("badgeCustom", false)) && StringUtils.isNotEmpty((CharSequence)(badge = (String)this.componentProperties.get("badgeTemplate", ""))) && (contentAccess = (ContentAccess)this.getSlingScriptHelper().getService(ContentAccess.class)) != null) {
                try (ResourceResolver adminResourceResolver = contentAccess.getAdminResourceResolver();){
                    ComponentProperties badgeConfig = ComponentsUtil.getTemplateConfig(ComponentsUtil.getContextObjects(this), badge, adminResourceResolver, (TagManager)adminResourceResolver.adaptTo(TagManager.class), "badgeFieldsTemplate", "badgeFields", "detailsBadge");
                    this.componentProperties.putAll((Map<? extends String, ?>)((Object)badgeConfig));
                }
                catch (Exception ex) {
                    LOGGER.error(Throwables.getStackTraceAsString((Throwable)ex));
                }
            }
            if (StringUtils.isEmpty((CharSequence)((CharSequence)this.componentProperties.get("variantTemplate", "")))) {
                String variant = (String)this.componentProperties.get("variant", "default");
                if (StringUtils.isEmpty((CharSequence)variant)) {
                    variant = "default";
                }
                String variantTemplate = ComponentsUtil.getComponentVariantTemplate(this.getComponent(), MessageFormat.format("variant.{0}.html", variant), this.getSlingScriptHelper());
                this.componentProperties.put("variantTemplate", variantTemplate);
            }
            this.componentProperties.put(PAGE_META_PROPERTY_FIELDS, GenericDetails.processPageMetaProperties(this.getResourcePage(), this.getResourceResolver(), this.getRequest(), this.componentProperties));
            this.componentProperties.put("canonicalUrl", ResolverUtil.mappedUrl(this.getResourceResolver(), this.getRequest(), this.getResourcePage().getPath()).concat(".html"));
            String legacyBadgeConfigTags = (String)this.componentProperties.get(FIELD_LEGACY_BADGE_CNNFIG_TAGS, "");
            if (StringUtils.isNotEmpty((CharSequence)legacyBadgeConfigTags)) {
                LinkedHashMap<String, Map> legacyBadgeConfig = TagUtil.getTagsAsAdmin(this.getSlingScriptHelper(), new String[]{legacyBadgeConfigTags}, this.getRequest().getLocale(), new String[]{"templates", "fields"}, true);
                this.componentProperties.put(FIELD_LEGACY_BADGE_CONFIG, legacyBadgeConfig);
            }
        }
        catch (Exception ex) {
            LOGGER.error("processCommonFields: could not process fields componentProperties={}, ex={}", (Object)this.componentProperties, (Object)ex);
        }
    }

    public Map<String, Resource> getFields() {
        return ComponentsUtil.getLocalSubResourcesInSuperComponent(this.getComponent(), "field", this.getSlingScriptHelper());
    }

    public Map<String, Resource> getTemplates() {
        return ComponentsUtil.getLocalSubResourcesInSuperComponent(this.getComponent(), "template", this.getSlingScriptHelper());
    }

    public String[] getRequestedFields() {
        String[] fields;
        String legacyComponentBadge = CommonUtil.getBadgeFromSelectors(this.getRequest().getRequestPathInfo().getSelectorString());
        if (StringUtils.isNotEmpty((CharSequence)legacyComponentBadge) && this.componentProperties != null) {
            LinkedHashMap legacyBadgeConfig = (LinkedHashMap)this.componentProperties.get(FIELD_LEGACY_BADGE_CONFIG, LinkedHashMap.class);
            if (legacyBadgeConfig != null) {
                for (Map.Entry entry : legacyBadgeConfig.entrySet()) {
                    Object value;
                    Map config = (Map)entry.getValue();
                    if (!config.containsKey("value") || !config.get("value").equals(legacyComponentBadge)) continue;
                    Object[] fields2 = new String[]{};
                    Object[] templates = new String[]{};
                    if (config.containsKey("fields") && (value = config.get("fields")) != null && value.getClass().isArray()) {
                        fields2 = (String[])config.get("fields");
                    }
                    if (config.containsKey("templates") && (value = config.get("templates")) != null && value.getClass().isArray()) {
                        templates = (String[])config.get("templates");
                    }
                    this.componentProperties.put(FIELD_LEGACY_BADGE_SELECTED, true);
                    return (String[])ArrayUtils.addAll((Object[])templates, (Object[])fields2);
                }
            } else {
                Object[] legacyBadges;
                int badgeMapIndex;
                String[][] legacyBadgeMapping = (String[][])this.componentProperties.get(FIELD_LEGACY_BADGE_LIST_MAPPING, legacyBadgeListMapping);
                if (legacyBadgeMapping.length > (badgeMapIndex = ArrayUtils.indexOf((Object[])(legacyBadges = (String[])this.componentProperties.get(FIELD_LEGACY_BADGE, legacyBadgeList)), (Object)legacyComponentBadge))) {
                    this.componentProperties.put(FIELD_LEGACY_BADGE_SELECTED, true);
                    return legacyBadgeMapping[badgeMapIndex];
                }
            }
        }
        if ((fields = this.getSlingScriptHelper().getRequest().getRequestPathInfo().getSelectors()).length > 0) {
            return fields;
        }
        fields = (String[])this.componentProperties.get("variantFields", new String[0]);
        if (fields.length > 0) {
            return fields;
        }
        return new String[0];
    }

    public static Map<String, Object> processBadgeConfig(Page page, ComponentProperties componentProperties) {
        HashMap<String, Object> badgeConfig = new HashMap<String, Object>();
        HashMap<String, String> badgeLinkAttr = new HashMap<String, String>();
        badgeLinkAttr.put("target", (String)componentProperties.get("linkTarget", ""));
        if (StringUtils.isNotEmpty((CharSequence)CommonUtil.getPageRedirect(page))) {
            badgeLinkAttr.put("external", "true");
        }
        badgeLinkAttr.put("data-layer-track", (String)componentProperties.get("badgeAnalyticsTrack", ""));
        badgeLinkAttr.put("data-layer-location", (String)componentProperties.get("badgeAnalyticsLocation", ""));
        badgeLinkAttr.put("data-layer-label", (String)componentProperties.get("badgeAnalyticsLabel", ""));
        badgeLinkAttr.put("data-layer-componentpath", (String)componentProperties.get("componentInPagePath", ""));
        badgeConfig.put("badgeLinkAttr", badgeLinkAttr);
        HashMap<String, String> badgeImageAttr = new HashMap<String, String>();
        badgeImageAttr.put("data-asset-primary-id", (String)componentProperties.get("pageImageId", ""));
        badgeImageAttr.put("data-asset-primary-license", (String)componentProperties.get("pageImageLicenseInfo", ""));
        badgeImageAttr.put("data-asset-secondary-id", (String)componentProperties.get("pageSecondaryImageId", ""));
        badgeImageAttr.put("data-asset-secondary-license", (String)componentProperties.get("pageSecondaryImageLicenseInfo", ""));
        badgeImageAttr.put("width", (String)componentProperties.get("thumbnailWidth", ""));
        badgeImageAttr.put("height", (String)componentProperties.get("thumbnailHeight", ""));
        String pageSecondaryImageThumbnail = (String)componentProperties.get("pageSecondaryImageThumbnail", "");
        if (StringUtils.isNotEmpty((CharSequence)pageSecondaryImageThumbnail)) {
            badgeImageAttr.put("class", "secondary");
            badgeImageAttr.put("data-asset-secondary-src", pageSecondaryImageThumbnail);
        }
        badgeConfig.put("badgeImageAttr", badgeImageAttr);
        String badgeClassAttr = "";
        badgeClassAttr = badgeClassAttr + StringUtils.join((Object[])((Object[])componentProperties.get("cardStyle", new String[0])), (String)" ");
        badgeClassAttr = badgeClassAttr + StringUtils.join((Object[])((Object[])componentProperties.get("titleIcon", new String[0])), (String)" ");
        badgeClassAttr = badgeClassAttr + StringUtils.join((Object[])((Object[])componentProperties.get("cardAdditional", new String[0])), (String)" ");
        badgeConfig.put("badgeClassAttr", badgeClassAttr);
        String badgeClassIconAttr = "";
        badgeClassIconAttr = badgeClassIconAttr + StringUtils.join((Object[])((Object[])componentProperties.get("cardIcon", new String[0])), (String)" ");
        badgeConfig.put("badgeClassIconAttr", badgeClassIconAttr);
        String pageTitle = (String)componentProperties.get("pageTitle", "");
        badgeConfig.put("badgeTitle", pageTitle);
        if (Boolean.parseBoolean((String)componentProperties.get("badgeTitleTrim", ""))) {
            int badgeTitleTrimLengthMax = (Integer)componentProperties.get("badgeTitleTrimLengthMax", 20);
            if (StringUtils.isNotEmpty((CharSequence)pageTitle)) {
                if (pageTitle.length() > badgeTitleTrimLengthMax) {
                    pageTitle = pageTitle.substring(0, badgeTitleTrimLengthMax).concat((String)componentProperties.get("badgeTitleTrimLengthMaxSuffix", "..."));
                }
                badgeConfig.put("badgeTitle", pageTitle);
            }
        }
        String badgeDescription = (String)componentProperties.get("description", "");
        badgeConfig.put("badgeDescription", badgeDescription);
        if (Boolean.parseBoolean((String)componentProperties.get("badgeSummaryTrim", ""))) {
            int badgeSummaryLengthMax = (Integer)componentProperties.get("badgeSummaryLengthMax", 20);
            if (StringUtils.isNotEmpty((CharSequence)badgeDescription)) {
                if (badgeDescription.length() > badgeSummaryLengthMax) {
                    badgeDescription = badgeDescription.substring(0, badgeSummaryLengthMax).concat((String)componentProperties.get("badgeSummaryLengthMaxSuffix", "badgeSummaryLengthMaxSuffix"));
                }
                badgeConfig.put("badgeDescription", badgeDescription);
            }
        }
        return badgeConfig;
    }

    public static Map<String, String> processPageMetaProperties(Page page, ResourceResolver resourceResolver, SlingHttpServletRequest request, ComponentProperties componentProperties) {
        String[] pageMetaPropertyContent;
        HashMap<String, String> newFields = new HashMap<String, String>();
        String[] pageMetaProperty = (String[])componentProperties.get("pageMetaProperty", new String[0]);
        if (pageMetaProperty.length == (pageMetaPropertyContent = (String[])componentProperties.get("pageMetaPropertyContent", new String[0])).length) {
            for (int i = 0; i < pageMetaProperty.length; ++i) {
                String key = pageMetaProperty[i];
                String value = pageMetaPropertyContent[i];
                if (!StringUtils.isNotEmpty((CharSequence)key) && !StringUtils.isNotEmpty((CharSequence)value)) continue;
                newFields.put(key, value);
            }
        }
        if (!newFields.containsKey("og:url")) {
            newFields.put("og:url", ResolverUtil.mappedUrl(resourceResolver, request, page.getPath()).concat(".html"));
        }
        if (!newFields.containsKey("og:image")) {
            newFields.put("og:image", ResolverUtil.mappedUrl(resourceResolver, request, ImagesUtil.getThumbnailUrl(page, resourceResolver)));
        }
        if (!newFields.containsKey("og:title")) {
            newFields.put("og:title", (String)componentProperties.get("pageTitle", ""));
        }
        if (!newFields.containsKey("og:description")) {
            newFields.put("og:description", ComponentsUtil.getPageDescription(page));
        }
        return newFields;
    }

    public Map<String, Object> processComponentFields(ComponentProperties componentProperties, I18n i18n, SlingScriptHelper sling) {
        HashMap<String, Object> newFields = new HashMap<String, Object>();
        try {
            String formattedTitle = ComponentsUtil.compileComponentMessage(FIELD_FORMAT_TITLE, DEFAULT_FORMAT_TITLE, componentProperties, sling);
            Document fragment = Jsoup.parse(formattedTitle);
            String formattedTitleText = fragment.text();
            newFields.put(FIELD_FORMATTED_TITLE, formattedTitle.trim());
            newFields.put(FIELD_FORMATTED_TITLE_TEXT, formattedTitleText.trim());
        }
        catch (Exception ex) {
            LOGGER.error("Could not process component fields in {}", (Object)COMPONENT_DETAILS_NAME);
        }
        return newFields;
    }
}

