/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.layout;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.components.Toolbar;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

public class Columns
extends ModelProxy {
    private static final String COLUMN_CLASS = "col-sm";
    private static final String ROW_CLASS = "row";
    private static final String COLUMNS_CLASS = "parsys_column";
    private static final String FIELD_LAYOUT = "layout";
    private static final String FIELD_NUMBER_OF_COLUMNS = "numCols";
    private static final String COLUMN_CLASS_FORMAT = "{0} {1} {2} {3}";
    protected ComponentProperties componentProperties = null;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private Type controlType;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String placeholderText;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String columnClass;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String columnsClass;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String rowClass;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={0})
    private int currentColumn;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={0})
    private int numCols;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    public Type getControlType() {
        return this.controlType;
    }

    public String getPlaceholderText() {
        return this.placeholderText;
    }

    public String getColumnClass() {
        return this.columnClass;
    }

    public String getColumnsClass() {
        return this.columnsClass;
    }

    public String getRowClass() {
        return this.rowClass;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public int getNumCols() {
        return this.numCols;
    }

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_I18N_CATEGORY = "columns";
        String DEFAULT_LAYOUT = "1;colctrl-1c";
        String COMPONENT_NAMESPACE = "aemdesign.components.layout.colctrl";
        String COMPONENT_NAMESPACE_PROPERTIES = ".componentProperties";
        String COMPONENT_NAMESPACE_CURRENTCOLUMN = ".currentColumn";
        this.setComponentFields(new Object[][]{{"variant", "default"}, {FIELD_LAYOUT, "1;colctrl-1c"}, {"layoutColumnClassSmall", new String[0], "", Tag.class.getCanonicalName()}, {"layoutColumnClassMedium", new String[0], "", Tag.class.getCanonicalName()}, {"layoutColumnClassLarge", new String[0], "", Tag.class.getCanonicalName()}, {"layoutColumnClassExtraLarge", new String[0], "", Tag.class.getCanonicalName()}, {"layoutRowClass", new String[0], "", Tag.class.getCanonicalName()}});
        this.placeholderText = "";
        ValueMap resourceProperties = (ValueMap)this.getResource().adaptTo(ValueMap.class);
        String controlTypeString = "";
        if (resourceProperties != null) {
            controlTypeString = (String)resourceProperties.get("controlType", (Object)"");
        }
        this.controlType = Type.fromString(controlTypeString);
        if (!this.getWcmMode().isEdit()) {
            this.getComponentContext().setDecorate(false);
            this.getComponentContext().setDecorationTagName("");
        }
        String columnClassSmall = "";
        String columnClassMedium = "";
        String columnClassLarge = "";
        String columnClassXLarge = "";
        String aRowClass = "";
        String aColumnClass = "";
        switch (this.controlType) {
            case START: {
                this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object)this.getResource(), (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY});
                String currentLayout = (String)this.componentProperties.get(FIELD_LAYOUT, "1;colctrl-1c");
                if (currentLayout.contains(";")) {
                    this.componentProperties.put(FIELD_LAYOUT, currentLayout.substring(currentLayout.indexOf(59) + 1));
                    String numColsString = currentLayout.split(";")[0];
                    this.numCols = CommonUtil.tryParseInt(numColsString, 0);
                }
                this.componentProperties.put(FIELD_NUMBER_OF_COLUMNS, this.numCols);
                this.placeholderText = I18nUtil.getDefaultLabelIfEmpty("placeholderTextStart", "columns", "Start of {0} Columns", i18n, Integer.toString(this.numCols));
                columnClassSmall = (String)this.componentProperties.get("layoutColumnClassSmall", "");
                columnClassMedium = (String)this.componentProperties.get("layoutColumnClassMedium", "");
                columnClassLarge = (String)this.componentProperties.get("layoutColumnClassLarge", "");
                columnClassXLarge = (String)this.componentProperties.get("layoutColumnClassExtraLarge", "");
                aRowClass = (String)this.componentProperties.get("layoutRowClass", "");
                aColumnClass = MessageFormat.format(COLUMN_CLASS_FORMAT, columnClassSmall, columnClassMedium, columnClassLarge, columnClassXLarge).trim();
                this.columnClass = this.getColumnClass(this.currentColumn, this.componentProperties, aColumnClass);
                this.columnsClass = this.getColumnsClass(this.numCols);
                this.rowClass = this.getRowClass(aRowClass);
                this.componentProperties.attr.add("class", this.columnsClass);
                this.componentProperties.put("componentAttributes", ComponentsUtil.buildAttributesString(this.componentProperties.attr.getData(), null));
                this.componentProperties.put("rowClass", this.rowClass);
                this.componentProperties.put("columnsClass", this.columnsClass);
                this.getRequest().setAttribute("aemdesign.components.layout.colctrl".concat(".componentProperties"), (Object)this.componentProperties);
                this.getRequest().setAttribute("aemdesign.components.layout.colctrl".concat(".currentColumn"), (Object)(this.currentColumn + 1));
                if (this.getWcmMode().isDisabled()) break;
                this.getEditContext().getEditConfig().getToolbar().add(0, (Toolbar.Item)new Toolbar.Separator());
                this.getEditContext().getEditConfig().getToolbar().add(0, (Toolbar.Item)new Toolbar.Label(this.placeholderText));
                this.getEditContext().getEditConfig().setOrderable(Boolean.valueOf(false));
                break;
            }
            case END: {
                this.componentProperties = (ComponentProperties)((Object)this.getRequest().getAttribute("aemdesign.components.layout.colctrl".concat(".componentProperties")));
                this.currentColumn = (Integer)this.getRequest().getAttribute("aemdesign.components.layout.colctrl".concat(".currentColumn"));
                this.numCols = (Integer)this.componentProperties.get(FIELD_NUMBER_OF_COLUMNS, this.numCols);
                this.placeholderText = I18nUtil.getDefaultLabelIfEmpty("placeholderTextEnd", "columns", "End of {0} Columns", i18n, Integer.toString(this.numCols));
                this.getRequest().removeAttribute("aemdesign.components.layout.colctrl".concat(".componentProperties"));
                this.getRequest().removeAttribute("aemdesign.components.layout.colctrl".concat(".currentColumn"));
                if (this.getWcmMode().isDisabled()) break;
                this.getEditContext().getEditConfig().getToolbar().clear();
                this.getEditContext().getEditConfig().setOrderable(Boolean.valueOf(false));
                break;
            }
            case BREAK: {
                if (this.getRequest().getAttribute("aemdesign.components.layout.colctrl".concat(".componentProperties")) == null || this.getRequest().getAttribute("aemdesign.components.layout.colctrl".concat(".currentColumn")) == null) break;
                this.componentProperties = (ComponentProperties)((Object)this.getRequest().getAttribute("aemdesign.components.layout.colctrl".concat(".componentProperties")));
                this.currentColumn = (Integer)this.getRequest().getAttribute("aemdesign.components.layout.colctrl".concat(".currentColumn"));
                columnClassSmall = (String)this.componentProperties.get("layoutColumnClassSmall", "");
                columnClassMedium = (String)this.componentProperties.get("layoutColumnClassMedium", "");
                columnClassLarge = (String)this.componentProperties.get("layoutColumnClassLarge", "");
                columnClassXLarge = (String)this.componentProperties.get("layoutColumnClassExtraLarge", "");
                aColumnClass = MessageFormat.format(COLUMN_CLASS_FORMAT, columnClassSmall, columnClassMedium, columnClassLarge, columnClassXLarge).trim();
                this.columnClass = this.getColumnClass(this.currentColumn, this.componentProperties, aColumnClass);
                this.numCols = (Integer)this.componentProperties.get(FIELD_NUMBER_OF_COLUMNS, this.numCols);
                this.getRequest().setAttribute("aemdesign.components.layout.colctrl".concat(".currentColumn"), (Object)(this.currentColumn + 1));
                this.placeholderText = I18nUtil.getDefaultLabelIfEmpty("placeholderTextBreak", "columns", "Columns Break {0} of {1}", i18n, Integer.toString(this.currentColumn + 1), Integer.toString(this.numCols - 1));
                break;
            }
        }
    }

    final String getColumnClass(Integer colNumber, ComponentProperties componentProperties, String columnClassStyle) {
        List<Object> columnsFormat = new ArrayList();
        String defaultFormat = "1;colctrl-1c";
        String columnsClassName = "colctrl";
        if (componentProperties != null) {
            columnsFormat = Arrays.asList(((String)componentProperties.get(FIELD_LAYOUT, defaultFormat)).split(";"));
            columnsClassName = (String)componentProperties.get("class", columnsClassName);
        }
        if (!columnsFormat.isEmpty() && ((String)columnsFormat.get(0)).contains(",")) {
            StringBuilder columnClassBuilder = new StringBuilder();
            for (int i = 0; i < columnsFormat.size(); ++i) {
                String spacer = i == columnsFormat.size() - 1 ? "" : " ";
                columnClassBuilder.append(((String)columnsFormat.get(i)).split(",")[0]);
                columnClassBuilder.append(((String)columnsFormat.get(i)).split(",")[colNumber + 1]);
                columnClassBuilder.append(spacer);
            }
            return MessageFormat.format(COLUMN_CLASS_FORMAT, COLUMNS_CLASS, COLUMN_CLASS, columnClassBuilder, columnClassStyle);
        }
        return MessageFormat.format(COLUMN_CLASS_FORMAT, COLUMNS_CLASS, COLUMN_CLASS, columnsClassName, columnClassStyle);
    }

    final String getColumnsClass(Integer numCols) {
        return MessageFormat.format("colctrl-{0}c", numCols);
    }

    final String getRowClass(String rowClass) {
        return MessageFormat.format("{0} {1} {2}", COLUMNS_CLASS, ROW_CLASS, rowClass);
    }

    private static enum Type {
        START("start"),
        END("end"),
        BREAK("break"),
        NORMAL("");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String value) {
            for (Type s : Type.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return null;
        }
    }
}

