/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.layout;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.services.ContentAccess;
import design.aem.utils.components.ComponentDetailsUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.ImagesUtil;
import design.aem.utils.components.SecurityUtil;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentBlockLock
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ContentBlockLock.class);
    protected ComponentProperties componentProperties = null;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() throws Exception {
        ContentAccess contentAccess;
        Resource firstComponent;
        Resource componentresource;
        String componentId;
        String ariaLabelledBy;
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_I18N_CATEGORY = "contentblock";
        String DEFAULT_I18N_BACKTOTOP_LABEL = "backtotoplabel";
        String DEFAULT_I18N_BACKTOTOP_TITLE = "backtotoptitle";
        String DEFAULT_TITLE_TAG_TYPE = "h2";
        String FIELD_LOCKED = "islocked";
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"hideTitle", false}, {"hideTopLink", false}, {"islocked", true}, {"linksLeftTitle", ""}, {"linksRightTitle", ""}, {"dataTitle", ""}, {"dataScroll", ""}, {"linksRight", new String[0]}, {"linksLeft", new String[0]}, {"titleType", "h2"}, {"title", ""}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY});
        this.componentProperties.put("linksRightList", ComponentDetailsUtil.getPageListInfo((WCMUsePojo)this, this.getPageManager(), this.getResourceResolver(), (String[])this.componentProperties.get("linksRight", new String[0])));
        this.componentProperties.put("linksLeftList", ComponentDetailsUtil.getPageListInfo((WCMUsePojo)this, this.getPageManager(), this.getResourceResolver(), (String[])this.componentProperties.get("linksLeft", new String[0])));
        this.componentProperties.put("topLinkLabel", I18nUtil.getDefaultLabelIfEmpty("", "contentblock", "backtotoplabel", "contentblock", i18n, new String[0]));
        this.componentProperties.put("topLinkTitle", I18nUtil.getDefaultLabelIfEmpty("", "contentblock", "backtotoptitle", "contentblock", i18n, new String[0]));
        Node resourceNode = (Node)this.getResource().adaptTo(Node.class);
        if (((String)this.componentProperties.get("variant", "default")).equals("advsection") && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(ariaLabelledBy = (String)this.componentProperties.get("ariaLabelledBy", "")))) {
            String labelId = ComponentsUtil.getComponentId(null);
            if (resourceNode != null) {
                labelId = "heading-".concat(resourceNode.getName());
            }
            this.componentProperties.put("ariaLabelledBy", labelId);
            this.componentProperties.attr.add("aria-labelledby", labelId);
            this.componentProperties.put("componentAttributes", ComponentsUtil.buildAttributesString(this.componentProperties.attr.getData(), null));
        }
        String instanceName = this.getComponent().getCellName();
        if (resourceNode != null) {
            instanceName = resourceNode.getName();
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(componentId = (String)this.componentProperties.get("componentId", "")))) {
            instanceName = componentId;
        }
        this.componentProperties.put("instanceName", instanceName);
        Authorizable authorizable = (Authorizable)this.getResourceResolver().adaptTo(Authorizable.class);
        List<String> groups = Arrays.asList((String[])this.componentProperties.get("groups", new String[]{"administrators"}));
        if (SecurityUtil.isUserMemberOf(authorizable, groups)) {
            this.componentProperties.put("islocked", false);
        }
        this.componentProperties.put("bgvideo", (Object)ImagesUtil.getBackgroundVideoRenditions(this));
        this.componentProperties.put("bgimage", (Object)ImagesUtil.getBackgroundImageRenditions(this));
        String variant = (String)this.componentProperties.get("variant", "default");
        if (variant.equals("componentConfig") && StringUtils.contains((String)this.getRequest().getRequestPathInfo().getSelectorString(), (String)"showconfig") && (componentresource = this.getResource().getChild("par")) != null && componentresource.hasChildren() && (firstComponent = (Resource)componentresource.listChildren().next()) != null && (contentAccess = (ContentAccess)this.getSlingScriptHelper().getService(ContentAccess.class)) != null) {
            try (ResourceResolver adminResourceResolver = contentAccess.getAdminResourceResolver();){
                this.componentProperties.put("firstComponentConfig", ComponentsUtil.getComponentFieldsAndDialogMap(firstComponent, adminResourceResolver, this.getSlingScriptHelper()));
            }
            catch (Exception ex) {
                LOGGER.error("ContentBlock: error accessing component dialog component.path={}, ex={}", (Object)firstComponent.getPath(), (Object)ex);
            }
        }
    }
}

