/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.lists;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.wcm.api.Page;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.ResolverUtil;
import design.aem.utils.components.TagUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;

public class LanguageNavigation
extends ModelProxy {
    protected ComponentProperties componentProperties = null;
    private static final String SEARCH_LOGIC = "searchlogic";
    private static final String SEARCH_LOGIC_DEFAULT = "";
    private static final String FIELD_DESCRIPTION = "description";

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"languageSet", new String[0]}, {SEARCH_LOGIC, SEARCH_LOGIC_DEFAULT}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY});
        LinkedHashMap languageToggleMap = new LinkedHashMap();
        String appearanceOption = (String)this.componentProperties.get(SEARCH_LOGIC, String.class);
        boolean isShowRoot = "showRoot".equals(appearanceOption);
        boolean isShowNothing = "showNothing".equals(appearanceOption);
        String[] tagsFilterList = (String[])this.componentProperties.get("languageSet", new String[0]);
        LinkedHashMap<String, Map> languageMap = TagUtil.getTagsAsAdmin(this.getSlingScriptHelper(), tagsFilterList, this.getRequest().getLocale());
        if (!isShowNothing && languageMap != null || !languageMap.isEmpty()) {
            Page currentPage = this.getResourcePage();
            String languageRoot = SEARCH_LOGIC_DEFAULT;
            String pagePath = SEARCH_LOGIC_DEFAULT;
            if (currentPage != null) {
                pagePath = currentPage.getPath();
                languageRoot = LanguageUtil.getLanguageRoot((String)this.getResourcePage().getPath());
                pagePath = pagePath.substring(languageRoot.length());
            }
            String languageSiteParentPath = SEARCH_LOGIC_DEFAULT;
            Resource languageSiteRootPage = null;
            for (String key : languageMap.keySet()) {
                Page langPageRootPage;
                Map langTag = languageMap.get(key);
                String tagValue = (String)langTag.get("value");
                String tagTitle = (String)langTag.get("title");
                String tagDescription = (String)langTag.get(FIELD_DESCRIPTION);
                if (StringUtils.isEmpty((CharSequence)languageSiteParentPath)) {
                    languageRoot = languageRoot.substring(0, languageRoot.indexOf(tagValue));
                    languageSiteRootPage = this.getResourceResolver().resolve(languageRoot);
                    if (!ResourceUtil.isNonExistingResource((Resource)languageSiteRootPage)) {
                        languageSiteParentPath = languageSiteRootPage.getPath();
                    }
                }
                String langPageRootPath = MessageFormat.format("{0}/{1}", languageSiteParentPath, tagValue);
                String langPagePath = MessageFormat.format("{0}/{1}{2}", languageSiteParentPath, tagValue, pagePath);
                Resource langPageRoot = this.getResourceResolver().resolve(langPageRootPath);
                Resource langPage = this.getResourceResolver().resolve(langPagePath);
                if (ResourceUtil.isNonExistingResource((Resource)langPageRoot)) {
                    langPageRoot = null;
                }
                if (ResourceUtil.isNonExistingResource((Resource)langPage)) {
                    langPage = null;
                }
                if (langPage != null && langPageRoot != null) {
                    Page langPageRootPage2;
                    HashMap<String, String> pageInfo = new HashMap<String, String>();
                    pageInfo.put("path", ResolverUtil.mappedUrl(this.getResourceResolver(), langPage.getPath()).concat(".html"));
                    pageInfo.put(FIELD_DESCRIPTION, tagDescription);
                    pageInfo.put("displayTitle", tagTitle);
                    if (langPagePath.startsWith(languageRoot)) {
                        pageInfo.put("current", "true");
                    }
                    if ((langPageRootPage2 = (Page)langPageRoot.adaptTo(Page.class)) != null) {
                        String hrefLang = langPageRootPage2.getLanguage().toLanguageTag();
                        String language = langPageRootPage2.getLanguage().toString();
                        pageInfo.put("hreflang", hrefLang);
                        pageInfo.put("language", language);
                    }
                    languageToggleMap.put(tagValue, pageInfo);
                    continue;
                }
                if (!isShowRoot || langPageRoot == null || (langPageRootPage = (Page)langPageRoot.adaptTo(Page.class)) == null) continue;
                String hrefLang = langPageRootPage.getLanguage().toLanguageTag();
                String language = langPageRootPage.getLanguage().toString();
                HashMap<String, String> pageInfo = new HashMap<String, String>();
                pageInfo.put("path", ResolverUtil.mappedUrl(this.getResourceResolver(), langPageRootPage.getPath()).concat(".html"));
                pageInfo.put(FIELD_DESCRIPTION, langPageRootPage.getDescription());
                pageInfo.put("displayTitle", langPageRootPage.getTitle());
                pageInfo.put("hreflang", hrefLang);
                pageInfo.put("language", language);
                if (langPagePath.startsWith(languageRoot)) {
                    pageInfo.put("current", "true");
                }
                languageToggleMap.put(langPageRootPage.getName(), pageInfo);
            }
        }
        this.componentProperties.put("languageMap", languageToggleMap);
    }
}

