/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.lists;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.SimpleSearch;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.ResultPage;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.text.Text;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.ImagesUtil;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class List
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(List.class);
    private static final int LIMIT_DEFAULT = 100;
    private static final int PAGEMAX_DEFAULT = -1;
    private static final int PN_DEPTH_DEFAULT = 1;
    private static final int LIST_SPLIT_EVERY_DEFAULT = 5;
    private static final String TAGS_MATCH_ANY_VALUE = "any";
    private static final String PN_DATE_FORMAT_DEFAULT = "yyyy-MM-dd";
    private static final String PN_SOURCE = "listFrom";
    private static final String PN_PAGES = "pages";
    private static final String PN_PARENT_PAGE = "parentPage";
    private static final String DESCENDANT_TAG = "ancestorTag";
    private static final String PN_PARENT_PAGE_DEFAULT = "/content";
    private static final String PN_TAGS_PARENT_PAGE = "tagsSearchRoot";
    private static final String PN_TAGS = "tags";
    private static final String PN_TAGS_MATCH = "tagsMatch";
    private static final String LIMIT_PROPERTY_NAME = "limit";
    private static final String PAGE_MAX_PROPERTY_NAME = "pageMax";
    private static final String PAGE_START_PROPERTY_NAME = "pageStart";
    private static final String ANCESTOR_PAGE_PROPERTY_NAME = "ancestorPage";
    private static final String SEARCH_IN_PROPERTY_NAME = "searchIn";
    private static final String SAVEDQUERY_PROPERTY_NAME = "savedquery";
    private static final String LIST_SPLIT_EVERY = "listSplitEvery";
    private static final String SHOW_HIDDEN = "showHidden";
    private static final String SHOW_INVALID = "showInvalid";
    private static final String DETAILS_BADGE = "detailsBadge";
    private static final String PAGINATION_TYPE = "paginationType";
    private static final String REQUEST_PARAM_MARKER_START = "start";
    private static final String REQUEST_PARAM_MARKER_MAX = "max";
    private static final String REQUEST_PARAM_QUERY = "q";
    private static final String QUERY_ENCODING = "UTF-8";
    public static final String LIST_TAG_ORDERED = "ol";
    public static final String LIST_TAG_UNORDERED = "ul";
    public static final String LIST_TAG = "listTag";
    public static final String LIST_ISPAGINATING = "isPaginating";
    public static final String LIST_ISEMPTY = "isEmpty";
    private static final String PN_SEARCH_IN = "searchIn";
    private static final String PN_QUERY = "query";
    private static final String PN_SORT_ORDER = "sortOrder";
    private static final String PN_ORDER_BY = "orderBy";
    private static final String PN_ORDER_BY_DEFAULT = "path";
    private static final Boolean DEFAULT_PRINT_STRUCTURE = true;
    private static final String DEFAULT_TITLE_TYPE = "h2";
    private static final String DEFAULT_I18N_CATEGORY = "list";
    private static final String DEFAULT_PAGINATION = "default";
    protected ComponentProperties componentProperties = null;
    public static final String LISTITEM_LINK_TEXT = "listItemLinkText";
    public static final String LISTITEM_LINK_TITLE = "listItemLinkTitle";
    private static final String FIELD_FEED_ENABLED = "feedEnabled";
    private static final String FIELD_FEED_TYPE = "feedType";
    private static final String FIELD_FEED_EXT = "feedExt";
    private static final String FIELD_FEED_TITLE = "feedTitle";
    private static final String FIELD_FEED_URL = "feedUrl";
    private java.util.List<Map<String, Object>> listItems;
    private String startIn;
    private SortOrder sortOrder;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={100})
    private int limit;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String query;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String savedquery;
    private long pageMax;
    private long totalPages;
    private long pageStart;
    private long totalMatches;
    private long listSplitEvery;
    private String id;
    private boolean isPaginating;
    private java.util.List<ResultPage> resultPages;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String detailsBadge;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected String[] detailsNameSuffix;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(booleanValues={false})
    private boolean showHidden;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(booleanValues={false})
    private boolean showInvalid;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        this.loadConfig();
    }

    protected void loadConfig() {
        String requestPageMax;
        String requestPageStart;
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String resourcePath = this.getResource().getPath();
        this.setComponentFields(new Object[][]{{LIST_TAG, LIST_TAG_UNORDERED}, {FIELD_FEED_ENABLED, false}, {FIELD_FEED_TYPE, "rss"}, {"listSplit", false, "data-list-split-enabled"}, {LIST_SPLIT_EVERY, 5, "data-list-split-every"}, {DETAILS_BADGE, DEFAULT_PAGINATION, "data-badge"}, {"printStructure", DEFAULT_PRINT_STRUCTURE}, {"topicQueue", "", "topicqueue"}, {SHOW_HIDDEN, false}, {SHOW_INVALID, false}, {PAGINATION_TYPE, DEFAULT_PAGINATION}, {LIMIT_PROPERTY_NAME, 100}, {PAGE_MAX_PROPERTY_NAME, -1}, {ANCESTOR_PAGE_PROPERTY_NAME, ""}, {PN_PARENT_PAGE, this.getCurrentPage().getPath()}, {PN_SOURCE, ""}, {PN_PAGES, new String[0]}, {PN_TAGS_PARENT_PAGE, this.getCurrentPage().getPath()}, {PN_TAGS, new String[0]}, {PN_TAGS_MATCH, TAGS_MATCH_ANY_VALUE}, {PN_ORDER_BY, ""}, {PN_QUERY, ""}, {PN_SORT_ORDER, SortOrder.ASC.getValue()}, {"searchIn", this.getResourcePage().getPath()}, {SAVEDQUERY_PROPERTY_NAME, ""}, {"searchIn", ""}, {LISTITEM_LINK_TEXT, I18nUtil.getDefaultLabelIfEmpty("", DEFAULT_I18N_CATEGORY, LISTITEM_LINK_TEXT, DEFAULT_I18N_CATEGORY, i18n, new String[0])}, {LISTITEM_LINK_TITLE, I18nUtil.getDefaultLabelIfEmpty("", DEFAULT_I18N_CATEGORY, LISTITEM_LINK_TITLE, DEFAULT_I18N_CATEGORY, i18n, new String[0])}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS});
        this.generateId();
        Object[] tags = (String[])this.componentProperties.get("cq:tags", new String[0]);
        this.componentProperties.attr.add("data-search-tags", StringUtils.join((Object[])tags, (String)","));
        this.startIn = (String)this.componentProperties.get("searchIn", this.getResourcePage().getPath());
        this.sortOrder = SortOrder.fromString((String)this.componentProperties.get(PN_SORT_ORDER, SortOrder.ASC.getValue()));
        this.savedquery = (String)this.componentProperties.get(SAVEDQUERY_PROPERTY_NAME, "");
        this.pageMax = ((Integer)this.componentProperties.get(PAGE_MAX_PROPERTY_NAME, -1)).intValue();
        this.listSplitEvery = ((Integer)this.componentProperties.get(LIST_SPLIT_EVERY, 5)).intValue();
        this.detailsBadge = (String)this.componentProperties.get(DETAILS_BADGE, DEFAULT_PAGINATION);
        this.limit = (Integer)this.componentProperties.get(LIMIT_PROPERTY_NAME, 100);
        this.showHidden = (Boolean)this.componentProperties.get(SHOW_HIDDEN, false);
        this.showInvalid = (Boolean)this.componentProperties.get(SHOW_INVALID, false);
        this.query = (String)this.componentProperties.get(PN_QUERY, "");
        if (this.detailsNameSuffix == null) {
            this.detailsNameSuffix = CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX;
        }
        if (StringUtils.isNotEmpty((CharSequence)(requestPageStart = this.getParameter(REQUEST_PARAM_MARKER_START)))) {
            this.pageStart = CommonUtil.tryParseLong(requestPageStart, 0L);
            this.componentProperties.put(PAGE_START_PROPERTY_NAME, this.pageStart);
        }
        if (StringUtils.isNotEmpty((CharSequence)(requestPageMax = this.getParameter(REQUEST_PARAM_MARKER_MAX)))) {
            this.pageMax = CommonUtil.tryParseLong(requestPageMax, this.pageMax);
            this.componentProperties.put(PAGE_MAX_PROPERTY_NAME, this.pageStart);
        }
        if (this.getRequest().getRequestParameter(REQUEST_PARAM_QUERY) != null) {
            try {
                RequestParameter requestParameter = this.getRequest().getRequestParameter(REQUEST_PARAM_QUERY);
                if (requestParameter != null) {
                    this.query = requestParameter.toString();
                }
            }
            catch (Exception ex) {
                LOGGER.error("could not read query param {}", (Throwable)ex);
            }
        }
        if (((Boolean)this.componentProperties.get(FIELD_FEED_ENABLED)).booleanValue()) {
            if ("atom".equals(this.componentProperties.get(FIELD_FEED_TYPE))) {
                this.componentProperties.put(FIELD_FEED_EXT, ".feed");
                this.componentProperties.put(FIELD_FEED_TITLE, "Atom 1.0 (List)");
                this.componentProperties.put(FIELD_FEED_TYPE, "application/atom+xml");
            } else if ("ics".equals(this.componentProperties.get(FIELD_FEED_TYPE))) {
                this.componentProperties.put(FIELD_FEED_EXT, ".ics");
                this.componentProperties.put(FIELD_FEED_TITLE, "iCalendar Subscription List");
                this.componentProperties.put(FIELD_FEED_TYPE, "text/calendar");
            } else {
                this.componentProperties.put(FIELD_FEED_EXT, ".rss");
                this.componentProperties.put(FIELD_FEED_TITLE, "RSS Feed");
                this.componentProperties.put(FIELD_FEED_TYPE, "application/rss+xml");
            }
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.componentProperties.get(FIELD_FEED_EXT, "")))) {
                this.componentProperties.put(FIELD_FEED_URL, resourcePath.concat((String)this.componentProperties.get(FIELD_FEED_EXT, "")));
            } else {
                this.componentProperties.put(FIELD_FEED_URL, resourcePath);
            }
        }
        String strItemLimit = (String)this.componentProperties.get(LIMIT_PROPERTY_NAME, "");
        String strPageItems = (String)this.componentProperties.get(PAGE_MAX_PROPERTY_NAME, "");
        if (StringUtils.isBlank((CharSequence)strItemLimit) && !StringUtils.isBlank((CharSequence)strPageItems)) {
            this.limit = Integer.MAX_VALUE;
        }
        Object[][] badgeComponentFields = new Object[][]{{"pageTitle", ""}, {"pageNavTitle", ""}};
        ComponentProperties badgeRequestAttributes = ComponentsUtil.getComponentProperties((WCMUsePojo)this, false, (Object[][][])new Object[][][]{badgeComponentFields, ComponentsUtil.DEFAULT_FIELDS_DETAILS_OPTIONS_OVERRIDE});
        badgeRequestAttributes.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getResourceImagePath(this.getResource(), "badgeThumbnail"), "badgeThumbnail"));
        this.componentProperties.put("badgeRequestAttributes", (Object)badgeRequestAttributes);
        try {
            this.getRequest().setAttribute("badgeRequestAttributes", (Object)badgeRequestAttributes);
            this.getRequest().setAttribute("componentProperties", (Object)this.componentProperties);
        }
        catch (Exception ex) {
            LOGGER.error("could not set request attributes for use in badges");
        }
        String paginationTemplate = String.format("pagination.%s.html", this.componentProperties.get(PAGINATION_TYPE, DEFAULT_PAGINATION));
        this.componentProperties.put("paginationTemplate", paginationTemplate);
        this.componentProperties.put("componentAttributes", ComponentsUtil.buildAttributesString(this.componentProperties.attr.getData(), null));
    }

    private void generateId() {
        String rootMarker;
        String path = this.getResource().getPath();
        int root = path.indexOf(rootMarker = "jcr:content".concat("/"));
        if (root >= 0) {
            path = path.substring(root + rootMarker.length());
        }
        this.id = path.replace("/", "_");
    }

    private String getParameter(String name) {
        return this.getRequest().getParameter(this.id + "_" + name);
    }

    private String getNextPageLink() {
        long nextPageStart = this.pageStart + this.pageMax;
        if (this.isPaginating && this.pageMax > 0L && this.resultPages.size() > 0 && nextPageStart < this.totalMatches) {
            PageLink link = new PageLink(this.getRequest());
            link.setParameter(REQUEST_PARAM_MARKER_START, nextPageStart);
            return link.toString();
        }
        return "";
    }

    private String getPreviousPageLink() {
        if (this.isPaginating && this.pageMax > 0L && this.resultPages.size() > 0 && this.pageStart != 0L) {
            long previousPageStart = this.pageStart > this.pageMax ? this.pageStart - this.pageMax : 0L;
            PageLink link = new PageLink(this.getRequest());
            link.setParameter(REQUEST_PARAM_MARKER_START, previousPageStart);
            return link.toString();
        }
        return "";
    }

    private Map<String, Object> getPageBadgeInfo(Page page) {
        return List.getPageBadgeInfo(page, this.detailsNameSuffix, this.getResourceResolver(), this.detailsBadge);
    }

    static Map<String, Object> getPageBadgeInfo(Page page, String[] detailsNameSuffix, ResourceResolver resourceResolver, String detailsBadge) {
        HashMap<String, Object> badge = new HashMap<String, Object>();
        try {
            String componentPath = CommonUtil.findComponentInPage(page, detailsNameSuffix);
            if (StringUtils.isNotEmpty((CharSequence)componentPath)) {
                Resource componentResource = resourceResolver.getResource(componentPath);
                if (componentResource != null) {
                    String componentResourceType = componentResource.getResourceType();
                    if (CommonUtil.isNull(componentResourceType)) {
                        componentResourceType = "";
                    }
                    badge.put("componentResourceType", componentResourceType);
                }
                badge.put("componentPath", componentPath);
                badge.put("componentPathSelectors", new String[]{"badge", detailsBadge});
                String pageRedirect = CommonUtil.getPageRedirect(page);
                if (StringUtils.isEmpty((CharSequence)pageRedirect)) {
                    badge.put("redirectLink", pageRedirect);
                }
            } else {
                LOGGER.warn("getPageBadgeInfo: page {} does not have component with resource type suffix {}", (Object)page.getPath(), (Object)detailsNameSuffix);
                badge.put("componentMissing", true);
            }
            badge.put("pagePath", page.getPath());
        }
        catch (Exception ex) {
            LOGGER.error("getPageBadgeInfo: could not get page info {}", (Throwable)ex);
        }
        return badge;
    }

    protected Source getListType() {
        String listFromValue = (String)this.componentProperties.get(PN_SOURCE, (String)this.getCurrentStyle().get(PN_SOURCE, (Object)""));
        return Source.fromString(listFromValue);
    }

    public Collection<Map<String, Object>> getListItems() {
        if (this.listItems == null) {
            Source listType = this.getListType();
            this.populateListItems(listType);
        }
        return this.listItems;
    }

    protected void populateListItems(Source listType) {
        switch (listType) {
            case STATIC: {
                this.populateStaticListItems();
                break;
            }
            case CHILDREN: {
                this.populateChildListItems();
                break;
            }
            case TAGS: {
                this.populateTagListItems();
                break;
            }
            case SEARCH: {
                this.populateSearchListItems();
                break;
            }
            case QUERYBUILDER: {
                this.populateQueryListItems();
                break;
            }
            case DESCENDANTS: {
                this.populateDescendantsListItems();
                break;
            }
            default: {
                this.listItems = new ArrayList<Map<String, Object>>();
            }
        }
        this.componentProperties.put(LIST_ISEMPTY, this.totalMatches == 0L);
        this.updateIsPaginating();
        this.updateListSplit();
        this.componentProperties.put("nextPageLink", this.getNextPageLink());
        this.componentProperties.put("previousPageLink", this.getPreviousPageLink());
    }

    private void updateIsPaginating() {
        this.componentProperties.attr.add("data-has-pages", Boolean.valueOf(this.isPaginating));
        if (this.isPaginating) {
            this.componentProperties.attr.add("data-total-pages", String.valueOf(this.totalPages));
            this.componentProperties.attr.add("data-content-url", this.getResource().getPath().concat(".html"));
            this.componentProperties.attr.add("data-content-start", this.id.concat("_start"));
        }
    }

    private void updateListSplit() {
        for (int i = 0; i < this.listItems.size(); ++i) {
            if ((long)(i + 1) % this.listSplitEvery != 0L) continue;
            this.listItems.get(i).put("split", true);
        }
    }

    static boolean includePageInList(Page page, boolean includeInvalid, boolean includeHidden) {
        return !(!includeHidden && page.isHideInNav() || !includeInvalid && !page.isValid() || page.getDeleted() != null);
    }

    private void populateStaticListItems() {
        this.listItems = new ArrayList<Map<String, Object>>();
        String[] resourcePaths = (String[])this.componentProperties.get(PN_PAGES, new String[0]);
        ResourceResolver resourceResolver = this.getResourceResolver();
        for (String path : resourcePaths) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            Resource pathResource = resourceResolver.resolve(path);
            if (ResourceUtil.isNonExistingResource((Resource)pathResource)) {
                LOGGER.error("populateStaticListItems: skipping item as it does not exist {}", (Object)path);
                continue;
            }
            item.put("type", pathResource.getResourceType());
            item.put("resource", pathResource);
            Page page = this.getPageManager().getContainingPage(path);
            if (page == null || !List.includePageInList(page, this.showInvalid, this.showHidden)) continue;
            item.put("page", page);
            item.putAll(this.getPageBadgeInfo(page));
            this.listItems.add(item);
        }
    }

    private void populateChildListItems() {
        String path = (String)this.componentProperties.get(PN_PARENT_PAGE, PN_PARENT_PAGE_DEFAULT);
        this.populateChildListItems(path, true);
    }

    private void populateDescendantsListItems() {
        String path = (String)this.componentProperties.get(DESCENDANT_TAG, PN_PARENT_PAGE_DEFAULT);
        this.populateChildListItems(path, false);
    }

    private void populateChildListItems(String path, Boolean flat) {
        this.listItems = new ArrayList<Map<String, Object>>();
        HashMap<String, String> childMap = new HashMap<String, String>();
        Page rootPage = this.getPageManager().getPage(path);
        childMap.put(PN_ORDER_BY_DEFAULT, rootPage.getPath());
        if (flat.booleanValue()) {
            childMap.put("path.flat", "true");
        } else {
            childMap.put("path.flat", "false");
        }
        childMap.put("type", "cq:Page");
        this.populateListItemsFromMap(childMap);
    }

    private void populateTagListItems() {
        Page rootPage;
        this.listItems = new ArrayList<Map<String, Object>>();
        Object[] tags = (String[])this.componentProperties.get(PN_TAGS, new String[0]);
        boolean matchAny = ((String)this.componentProperties.get(PN_TAGS_MATCH, TAGS_MATCH_ANY_VALUE)).equals(TAGS_MATCH_ANY_VALUE);
        if (ArrayUtils.isNotEmpty((Object[])tags) && (rootPage = this.getPageManager().getPage((String)this.componentProperties.get(PN_TAGS_PARENT_PAGE, ""))) != null) {
            HashMap<String, String> childMap = new HashMap<String, String>();
            childMap.put(PN_ORDER_BY_DEFAULT, rootPage.getPath());
            String operator = matchAny ? "or" : "and";
            childMap.put("group.p." + operator, "true");
            String groupPrefix = "group.0_group.";
            String tagIdSuffix = "_group.tagid";
            childMap.put(groupPrefix + "p." + operator, "true");
            int offset = 0;
            for (Object tag : tags) {
                childMap.put(groupPrefix + offset + tagIdSuffix, (String)tag);
                childMap.put(groupPrefix + offset + tagIdSuffix + ".property", "jcr:content".concat("/cq:tags"));
                childMap.put(groupPrefix + ++offset + tagIdSuffix, (String)tag);
                childMap.put(groupPrefix + offset + tagIdSuffix + "property", "jcr:content".concat("/article/par/page_details/cq:tags"));
            }
            this.populateListItemsFromMap(childMap);
        }
    }

    private void populateSearchListItems() {
        SimpleSearch search;
        this.listItems = new ArrayList<Map<String, Object>>();
        if (!StringUtils.isBlank((CharSequence)this.query) && (search = (SimpleSearch)this.getResource().adaptTo(SimpleSearch.class)) != null) {
            search.setQuery(this.query);
            search.setSearchIn(this.startIn);
            if (this.limit > 0) {
                search.setHitsPerPage(this.pageMax);
            }
            try {
                this.collectSearchResults(search.getResult());
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to retrieve search results for query.", (Throwable)e);
            }
        }
    }

    public static PredicateGroup getPredicateGroupFromRequest(SlingHttpServletRequest request) {
        String queryParam = "";
        try {
            queryParam = request.getParameter(PN_QUERY);
            String isURLQuery = request.getParameter("isURL");
            if (queryParam != null && "on".equals(isURLQuery)) {
                queryParam = Text.unescape((String)queryParam.replaceAll("&", "\n"));
            }
        }
        catch (Exception ex) {
            LOGGER.error("getPredicateGroupFromQuery: could not read query param q=[{}], ex={}", (Object)queryParam, (Object)ex);
            return null;
        }
        return List.getPredicateGroupFromQuery(queryParam);
    }

    public static PredicateGroup getPredicateGroupFromQuery(String queryParam) {
        try {
            Properties props = new Properties();
            props.load(new StringReader(queryParam));
            return PredicateConverter.createPredicates((Map)props);
        }
        catch (Exception ex) {
            LOGGER.error("getPredicateGroupFromQuery: could not create PredicateGroupFromQuery from query param q=[{}], ex={}", (Object)queryParam, (Object)ex);
            return null;
        }
    }

    private void populateListItemsFromQuery(String queryParam) {
        try {
            QueryBuilder builder = (QueryBuilder)this.getResourceResolver().adaptTo(QueryBuilder.class);
            if (builder != null) {
                Session session = (Session)this.getResourceResolver().adaptTo(Session.class);
                Query query = null;
                PredicateGroup root = List.getPredicateGroupFromQuery(queryParam);
                if (root != null && !root.isEmpty()) {
                    query = builder.createQuery(root, session);
                }
                if (query != null) {
                    this.collectSearchResults(query.getResult());
                }
            } else {
                LOGGER.error("populateListItemsFromMap: could not get query builder object, q={}", (Object)queryParam);
            }
        }
        catch (Exception ex) {
            LOGGER.error("populateListItemsFromQuery: could not execute query q=[{}], ex={}", (Object)queryParam, (Object)ex);
        }
    }

    private void populateListItemsFromMap(Map<String, String> map) {
        try {
            QueryBuilder builder = (QueryBuilder)this.getResourceResolver().adaptTo(QueryBuilder.class);
            if (builder != null) {
                String orderBy;
                Session session = (Session)this.getResourceResolver().adaptTo(Session.class);
                Query query = null;
                if (this.pageMax > 0L) {
                    map.put("p.limit", String.valueOf(this.pageMax));
                } else if (this.limit > 0) {
                    map.put("p.limit", String.valueOf(this.limit));
                }
                if (this.pageStart > 0L) {
                    map.put("p.offset", String.valueOf(this.pageStart));
                }
                if (StringUtils.isNotEmpty((CharSequence)(orderBy = (String)this.componentProperties.get(PN_ORDER_BY, PN_ORDER_BY_DEFAULT)))) {
                    map.put("orderby", orderBy);
                } else {
                    map.put("orderby", PN_ORDER_BY_DEFAULT);
                }
                map.put("orderby.sort", this.sortOrder.getValue());
                PredicateGroup root = PredicateGroup.create(map);
                if (!root.isEmpty()) {
                    query = builder.createQuery(root, session);
                }
                if (query != null) {
                    this.collectSearchResults(query.getResult());
                }
            } else {
                LOGGER.error("populateListItemsFromMap: could not get query builder object, map=[{}]", map);
            }
        }
        catch (Exception ex) {
            LOGGER.error("populateListItemsFromMap: could not execute query map=[{}], ex={}", map, (Object)ex);
        }
    }

    private void populateQueryListItems() {
        block13: {
            this.listItems = new ArrayList<Map<String, Object>>();
            if (!StringUtils.isBlank((CharSequence)this.savedquery)) {
                try {
                    if (this.getRequest().getRequestParameter(REQUEST_PARAM_QUERY) != null) {
                        String escapedQuery = "";
                        RequestParameter requestParameter = this.getRequest().getRequestParameter(REQUEST_PARAM_QUERY);
                        if (requestParameter != null) {
                            escapedQuery = requestParameter.toString();
                        }
                        String unescapedQuery = URLDecoder.decode(escapedQuery, QUERY_ENCODING);
                        QueryBuilder queryBuilder = (QueryBuilder)this.getResourceResolver().adaptTo(QueryBuilder.class);
                        if (queryBuilder != null) {
                            PageManager pm = (PageManager)this.getResourceResolver().adaptTo(PageManager.class);
                            Properties props = new Properties();
                            props.load(new ByteArrayInputStream(unescapedQuery.getBytes()));
                            PredicateGroup predicateGroup = PredicateConverter.createPredicates((Map)props);
                            Session jcrSession = (Session)this.getResourceResolver().adaptTo(Session.class);
                            if (jcrSession != null) {
                                Query query = queryBuilder.createQuery(predicateGroup, jcrSession);
                                if (query != null) {
                                    this.collectSearchResults(query.getResult());
                                }
                            } else {
                                LOGGER.error("populateQueryListItems: could not get sessions object");
                            }
                        } else {
                            LOGGER.error("populateQueryListItems: could not get query builder object");
                        }
                        break block13;
                    }
                    Session session = (Session)this.getResourceResolver().adaptTo(Session.class);
                    QueryBuilder queryBuilder = (QueryBuilder)this.getResourceResolver().adaptTo(QueryBuilder.class);
                    if (session == null || queryBuilder == null) break block13;
                    try {
                        Query query = queryBuilder.loadQuery(this.getResource().getPath() + "/" + SAVEDQUERY_PROPERTY_NAME, session);
                        if (query != null) {
                            this.collectSearchResults(query.getResult());
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("error loading stored querybuilder query from {},{}", (Object)this.getResource().getPath(), (Object)ex);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("LIST: could not do query {}", (Throwable)ex);
                }
            }
        }
    }

    private void collectSearchResults(SearchResult result) throws RepositoryException {
        HashMap<String, Object> resultInfo = new HashMap<String, Object>();
        resultInfo.put("executionTime", result.getExecutionTime());
        resultInfo.put("startIndex", result.getStartIndex());
        resultInfo.put("hasMore", result.hasMore());
        resultInfo.put("result", result);
        this.totalMatches = result.getTotalMatches();
        this.resultPages = result.getResultPages();
        long hitsPerPage = result.getHitsPerPage();
        this.totalPages = result.getResultPages().size();
        this.pageStart = result.getStartIndex();
        long currentPage = this.pageStart / hitsPerPage + 1L;
        resultInfo.put("hitsPerPage", hitsPerPage);
        resultInfo.put("currentPage", currentPage);
        resultInfo.put("totalMatches", this.totalMatches);
        resultInfo.put("resultPages", this.resultPages);
        resultInfo.put("totalPages", this.totalPages);
        resultInfo.put(PAGE_START_PROPERTY_NAME, this.pageStart);
        this.isPaginating = this.pageMax > 0L && result.getResultPages().size() > 0;
        this.componentProperties.put(LIST_ISPAGINATING, this.isPaginating);
        this.componentProperties.put("resultInfo", resultInfo);
        for (Hit hit : result.getHits()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("hit", hit);
            item.put("resource", hit.getResource());
            item.put("type", hit.getResource().getResourceType());
            Page containingPage = this.getPageManager().getContainingPage(hit.getResource());
            if (containingPage == null || !List.includePageInList(containingPage, this.showInvalid, this.showHidden)) continue;
            item.put("page", containingPage);
            item.putAll(this.getPageBadgeInfo(containingPage));
            this.listItems.add(item);
        }
    }

    private class PageLink {
        private String path;
        private HashMap<String, Object> params;

        public PageLink(SlingHttpServletRequest request) {
            this.path = request.getPathInfo();
            PageManager pm = (PageManager)request.getResourceResolver().adaptTo(PageManager.class);
            if (pm != null) {
                Page page = pm.getContainingPage(this.path);
                if (page != null) {
                    this.path = page.getPath() + ".html";
                }
            } else {
                LOGGER.error("PageLink: could not get PageManager object");
            }
            this.initParams(request.getQueryString());
        }

        public void addParameter(String name, Object value) {
            name = this.prefixName(name);
            this.params.put(name, value);
        }

        public void setParameter(String name, Object value) {
            name = this.prefixName(name);
            this.params.remove(name);
            this.addParameter(name, value);
        }

        public String toString() {
            String url = this.path;
            for (String param : this.params.keySet()) {
                url = this.appendParam(url, param, this.params.get(param));
            }
            return url;
        }

        private String prefixName(String name) {
            if (!name.startsWith(List.this.id + "_")) {
                name = List.this.id + "_" + name;
            }
            return name;
        }

        private void initParams(String query) {
            String[] pairs;
            this.params = new HashMap();
            String[] arr$ = pairs = Text.explode((String)query, (int)38);
            int len$ = pairs.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String pair = arr$[i$];
                String[] param = Text.explode((String)pair, (int)61, (boolean)true);
                this.params.put(param[0], param[1]);
            }
        }

        private String appendParam(String url, String name, Object value) {
            char delim = url.indexOf(63) > 0 ? (char)'&' : '?';
            return url + delim + name + '=' + value;
        }
    }

    public static enum SortOrder {
        ASC("asc"),
        DESC("desc");

        private String value;

        public String getValue() {
            return this.value;
        }

        private SortOrder(String value) {
            this.value = value;
        }

        public static SortOrder fromString(String value) {
            for (SortOrder s : SortOrder.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return ASC;
        }
    }

    protected static enum Source {
        CHILDREN("children"),
        STATIC("static"),
        SEARCH("search"),
        TAGS("tags"),
        QUERYBUILDER("querybuilder"),
        DESCENDANTS("descendants"),
        EMPTY("");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String value) {
            for (Source s : Source.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return null;
        }
    }
}

