/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.lists;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.models.v2.lists.List;
import design.aem.utils.components.ComponentsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagList
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TagList.class);
    protected ComponentProperties componentProperties = null;
    private List<Map<String, Object>> listItems;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={100})
    private int limit;
    private static final String PN_SOURCE = "listFrom";
    private static final String PN_SOURCE_DEFAULT = Source.STATIC.getValue();
    private static final String PARENT_TAG = "parentTag";
    private static final String STATIC_TAGS = "tags";
    private static final String DESCENDANT_TAG = "ancestorTag";
    private static final String PARENT_TAG_DEFAULT = "/content/cq:tags";
    private static final String LIMIT_PROPERTY_NAME = "limit";
    private static final int LIMIT_DEFAULT = 100;
    private static final String PN_SORT_ORDER = "sortOrder";
    private static final String PN_ORDER_BY = "orderBy";
    private static final String PN_ORDER_BY_DEFAULT = "path";
    private static final String LIST_ISEMPTY = "isEmpty";
    private long totalMatches;
    private List.SortOrder sortOrder;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"displayType", ""}, {"emptyOption", true}, {"emptyOptionTitle", "Select"}, {"filter", false, "filter"}, {"filterDefaults", "", "filter-defaults"}, {"filterTopic", "", "filter-topic"}, {STATIC_TAGS, new String[0]}, {DESCENDANT_TAG, PARENT_TAG_DEFAULT}, {PN_SOURCE, PN_SOURCE_DEFAULT}, {PARENT_TAG, PARENT_TAG_DEFAULT}, {PN_ORDER_BY, ""}, {LIMIT_PROPERTY_NAME, 100}, {PN_SORT_ORDER, List.SortOrder.ASC.getValue()}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS});
        this.sortOrder = List.SortOrder.fromString((String)this.componentProperties.get(PN_SORT_ORDER, List.SortOrder.ASC.getValue()));
        this.limit = (Integer)this.componentProperties.get(LIMIT_PROPERTY_NAME, 100);
    }

    protected Source getListType() {
        if (this.componentProperties != null) {
            String listFromValue = (String)this.componentProperties.get(PN_SOURCE, (String)this.getCurrentStyle().get(PN_SOURCE, (Object)""));
            return Source.fromString(listFromValue);
        }
        return Source.STATIC;
    }

    public Collection<Map<String, Object>> getListItems() {
        if (this.listItems == null) {
            Source listType = this.getListType();
            this.populateListItems(listType);
        }
        return this.listItems;
    }

    protected void populateListItems(Source listType) {
        switch (listType) {
            case STATIC: {
                this.populateStaticListItems();
                break;
            }
            case CHILDREN: {
                this.populateChildListItems();
                break;
            }
            case DESCENDANTS: {
                this.populateDescendantsListItems();
                break;
            }
            default: {
                this.listItems = new ArrayList<Map<String, Object>>();
            }
        }
        this.componentProperties.put(LIST_ISEMPTY, this.totalMatches == 0L);
    }

    private void populateChildListItems() {
        String path = (String)this.componentProperties.get(PARENT_TAG, PARENT_TAG_DEFAULT);
        this.populateChildListItems(path, true);
    }

    private void populateDescendantsListItems() {
        String path = (String)this.componentProperties.get(DESCENDANT_TAG, PARENT_TAG_DEFAULT);
        this.populateChildListItems(path, false);
    }

    private void populateChildListItems(String path, Boolean flat) {
        this.listItems = new ArrayList<Map<String, Object>>();
        HashMap<String, String> childMap = new HashMap<String, String>();
        childMap.put(PN_ORDER_BY_DEFAULT, path);
        if (flat.booleanValue()) {
            childMap.put("path.flat", "true");
        } else {
            childMap.put("path.flat", "false");
        }
        childMap.put("type", "cq:Tag");
        this.populateListItemsFromMap(childMap);
    }

    private void populateListItemsFromMap(Map<String, String> map) {
        try {
            QueryBuilder builder = (QueryBuilder)this.getResourceResolver().adaptTo(QueryBuilder.class);
            if (builder != null) {
                Session session = (Session)this.getResourceResolver().adaptTo(Session.class);
                Query query = null;
                map.put("p.limit", String.valueOf(this.limit));
                String orderBy = (String)this.componentProperties.get(PN_ORDER_BY, PN_ORDER_BY_DEFAULT);
                if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
                    map.put("orderby", orderBy);
                } else {
                    map.put("orderby", PN_ORDER_BY_DEFAULT);
                }
                map.put("orderby.sort", this.sortOrder.getValue());
                PredicateGroup root = PredicateGroup.create(map);
                if (!root.isEmpty()) {
                    query = builder.createQuery(root, session);
                }
                if (query != null) {
                    this.collectSearchResults(query.getResult());
                }
            } else {
                LOGGER.error("populateListItemsFromMap: could not get query builder object, map=[{}]", map);
            }
        }
        catch (Exception ex) {
            LOGGER.error("populateListItemsFromMap: could not execute query map=[{}], ex={}", map, (Object)ex);
        }
    }

    private void populateStaticListItems() {
        this.listItems = new ArrayList<Map<String, Object>>();
        String[] tags = (String[])this.componentProperties.get(STATIC_TAGS, new String[0]);
        ResourceResolver resourceResolver = this.getResourceResolver();
        TagManager tagManager = (TagManager)resourceResolver.adaptTo(TagManager.class);
        if (tagManager != null) {
            for (String tagId : tags) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                Tag tag = tagManager.resolve(tagId);
                if (tag != null) {
                    item.put("tag", tag);
                    Resource tagResource = resourceResolver.resolve(tag.getPath());
                    if (!ResourceUtil.isNonExistingResource((Resource)tagResource)) {
                        ValueMap tagValues = tagResource.getValueMap();
                        item.put("value", tagValues.get((Object)"value"));
                    }
                } else {
                    LOGGER.error("populateStaticListItems: could not find tagId {}", (Object)tagId);
                    continue;
                }
                this.listItems.add(item);
            }
        } else {
            LOGGER.error("populateStaticListItems: could not get TagManager object");
        }
    }

    private void collectSearchResults(SearchResult result) throws RepositoryException {
        HashMap<String, Object> resultInfo = new HashMap<String, Object>();
        resultInfo.put("executionTime", result.getExecutionTime());
        resultInfo.put("result", result);
        this.totalMatches = result.getTotalMatches();
        List resultPages = result.getResultPages();
        long hitsPerPage = result.getHitsPerPage();
        long totalPages = result.getResultPages().size();
        long pageStart = result.getStartIndex();
        long currentPage = pageStart / hitsPerPage + 1L;
        resultInfo.put("hitsPerPage", hitsPerPage);
        resultInfo.put("currentPage", currentPage);
        resultInfo.put("totalMatches", this.totalMatches);
        resultInfo.put("resultPages", resultPages);
        resultInfo.put("totalPages", totalPages);
        this.componentProperties.put("resultInfo", resultInfo);
        for (Hit hit : result.getHits()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("hit", hit);
            Resource tagResource = hit.getResource();
            Tag tag = (Tag)tagResource.adaptTo(Tag.class);
            if (tag != null) {
                item.put("tag", tag);
                ValueMap tagValues = tagResource.getValueMap();
                if (tagValues != null && tagValues.containsKey((Object)"value")) {
                    item.put("value", tagValues.get((Object)"value"));
                }
            }
            this.listItems.add(item);
        }
    }

    protected static enum Source {
        CHILDREN("children"),
        STATIC("static"),
        DESCENDANTS("descendants"),
        EMPTY("");

        private String value;

        public String getValue() {
            return this.value;
        }

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String value) {
            for (Source s : Source.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return null;
        }
    }
}

