/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.widgets;

import com.adobe.cq.sightly.SightlyWCMMode;
import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.granite.ui.components.AttrBuilder;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import design.aem.components.ComponentProperties;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.TagUtil;
import design.aem.utils.components.TenantUtil;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vue
extends WCMUsePojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Vue.class);
    public ComponentProperties componentProperties = null;
    private AttrBuilder attrs = null;
    private StringBuilder componentHTML = new StringBuilder();
    private Map<String, String> configOutput = new HashMap<String, String>();
    private Map<String, String> slots = new HashMap<String, String>();

    public void activate() {
        Object[][] componentFields = new Object[][]{{"variant", "default"}, {"vueComponentName", ""}, {"analyticsName", ""}, {"analyticsLocation", ""}};
        this.attrs = new AttrBuilder((HttpServletRequest)this.getRequest(), this.getXSSAPI());
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{componentFields});
        String componentName = (String)this.componentProperties.get("vueComponentName", "");
        this.retrieveComponentConfigurationAndSlots(componentName);
        String googleMapApiKey = ComponentsUtil.getCloudConfigProperty((InheritanceValueMap)this.getPageProperties(), "googlemap", "googleApiKey", this.getSlingScriptHelper());
        this.attrs.add("google-maps-key", googleMapApiKey);
        this.setAnalyticsAttributes();
        this.constructComponentHTML(componentName);
        this.componentProperties.put("configOutput", this.configOutput);
    }

    private void setAnalyticsAttributes() {
        HashMap<String, String> analyticsAttrs = new HashMap<String, String>();
        analyticsAttrs.put("analytics-name", "analyticsName");
        analyticsAttrs.put("analytics-location", "analyticsLocation");
        for (Map.Entry attr : analyticsAttrs.entrySet()) {
            String value = (String)this.componentProperties.get((String)attr.getValue(), "");
            if (!StringUtils.isNotEmpty((String)value)) continue;
            this.attrs.add((String)attr.getKey(), value);
        }
    }

    private void retrieveComponentConfigurationAndSlots(String componentName) {
        Resource resource = this.getResource();
        if (resource != null) {
            Node resourceNode = (Node)resource.adaptTo(Node.class);
            try {
                Node dynamicNode;
                Node componentNode;
                if (resourceNode != null && resourceNode.hasNode("dynamic") && (componentNode = (dynamicNode = resourceNode.getNode("dynamic")).getNode(componentName)) != null) {
                    PropertyIterator properties = componentNode.getProperties();
                    NodeIterator nodes = componentNode.getNodes();
                    while (nodes.hasNext()) {
                        Node node = (Node)nodes.next();
                        if (node == null || node.getName().startsWith("jcr:")) continue;
                        this.handleComponentValue(componentName, node.getName(), "", node.getProperties());
                    }
                    while (properties.hasNext()) {
                        Property property = properties.nextProperty();
                        String name = property.getName();
                        if (name.startsWith("jcr:")) continue;
                        this.handleComponentValue(componentName, name, property.getValue().getString(), null);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("[Vue Component] Unable to load all or part of the dynamic configuration for: {}", (Object)resource.getPath());
                LOGGER.error(ex.getMessage());
            }
        }
    }

    private void handleComponentValue(String componentName, String fieldName, String fieldValue, PropertyIterator fieldProperties) {
        JsonObject fieldConfig = this.getFieldTagConfig(componentName, fieldName);
        SightlyWCMMode wcmMode = this.getWcmMode();
        boolean isSlot = false;
        String slotName = "";
        if (fieldConfig != null && fieldConfig.has("field")) {
            String fieldType = fieldConfig.get("field").getAsString();
            if (fieldType.equals("autocomplete")) {
                fieldValue = TagUtil.getTagValueAsAdmin(fieldValue, this.getSlingScriptHelper());
            }
            if (fieldType.equals("fileUpload") && fieldProperties != null) {
                while (fieldProperties.hasNext()) {
                    Property property = fieldProperties.nextProperty();
                    try {
                        if (!property.getName().equals("fileReference")) continue;
                        fieldValue = property.getString();
                        break;
                    }
                    catch (RepositoryException ex) {
                        LOGGER.error("Unable to handle property iterator step!, {}", (Object)property);
                        LOGGER.error(ex.getLocalizedMessage());
                    }
                }
            }
            String string = slotName = (isSlot = fieldConfig.has("slot")) ? fieldConfig.get("slot").getAsString() : slotName;
        }
        if (isSlot) {
            this.slots.put(slotName, fieldValue);
        } else {
            this.attrs.add(fieldName, fieldValue);
        }
        if (wcmMode.isEdit() || wcmMode.isPreview()) {
            this.configOutput.put(StringUtils.capitalize((String)fieldName), fieldValue);
        }
    }

    private JsonObject getFieldTagConfig(String componentName, String fieldName) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = null;
        try {
            String componentPath = "/content/%s/%s/component-dialog/vue-widgets/%s/%s";
            String tenantName = TenantUtil.resolveTenantIdFromPath(this.getResource().getPath());
            String resourcePath = String.format(componentPath, "cq:tags", tenantName, componentName, fieldName);
            Resource fieldResource = this.getResourceResolver().getResource(resourcePath);
            if (fieldResource == null) {
                throw new ResourceNotFoundException("Unable to get resource for: " + resourcePath);
            }
            String fieldValue = (String)fieldResource.getValueMap().get("value", (Object)"");
            String json = new String(Base64.getDecoder().decode(fieldValue));
            JsonElement parsedJson = parser.parse(json);
            if (parsedJson.isJsonObject()) {
                jsonObject = parsedJson.getAsJsonObject();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[Vue Component] Unable to parse JSON value for '{}' on component: '{}'", (Object)fieldName, (Object)componentName);
            LOGGER.error(ex.getMessage());
        }
        return jsonObject;
    }

    private void constructComponentHTML(String componentName) {
        this.componentHTML.append(String.format("<%s %s>", componentName, this.attrs.build()));
        if (this.slots.size() > 0) {
            for (Map.Entry<String, String> slot : this.slots.entrySet()) {
                this.componentHTML.append(String.format("<template v-slot:%s>%s</template>", slot.getKey(), slot.getValue()));
            }
        }
        this.componentHTML.append(String.format("</%s>", componentName));
    }

    public String getComponentHTML() {
        return this.componentHTML.toString();
    }
}

