/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentVariation;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFragmentUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ContentFragmentUtil.class);
    public static final String DEFAULT_CONTENTFRAGMENT_VARIATION = "master";

    public static Map<String, Object> getComponentFragmentMap(String contentFragmentPath, String variationName, ResourceResolver resourceResolver) {
        LinkedHashMap<String, Object> newFields = new LinkedHashMap<String, Object>();
        try {
            if (StringUtils.isNotEmpty((CharSequence)contentFragmentPath)) {
                Resource fragmentResource = resourceResolver.getResource(contentFragmentPath);
                if (!ResourceUtil.isNonExistingResource((Resource)fragmentResource) && fragmentResource != null) {
                    ContentFragment contentFragment = (ContentFragment)fragmentResource.adaptTo(ContentFragment.class);
                    if (contentFragment == null) {
                        LOGGER.error("Content Fragment can not be initialized because '{}' is not a content fragment.", (Object)fragmentResource.getPath());
                    } else {
                        if (StringUtils.isEmpty((CharSequence)variationName)) {
                            variationName = DEFAULT_CONTENTFRAGMENT_VARIATION;
                        }
                        Iterator contentElementIterator = contentFragment.getElements();
                        while (contentElementIterator.hasNext()) {
                            ContentElement contentElement = (ContentElement)contentElementIterator.next();
                            String name = contentElement.getName();
                            String value = null;
                            if (StringUtils.isNotEmpty((CharSequence)variationName) && !DEFAULT_CONTENTFRAGMENT_VARIATION.equals(variationName)) {
                                ContentVariation variation = contentElement.getVariation(variationName);
                                if (variation == null) {
                                    LOGGER.warn("Non-existing variation '{}' of element '{}'", (Object)variationName, (Object)contentElement.getName());
                                } else {
                                    value = variation.getContent();
                                }
                            } else {
                                value = contentElement.getContent();
                            }
                            newFields.put(name, value);
                        }
                    }
                }
            } else {
                LOGGER.error("Could not process content fragment as with empty path");
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not process content fragment: {} with variant {}", (Object)contentFragmentPath, (Object)variationName);
        }
        return newFields;
    }
}

