/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import design.aem.services.ContentAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TagUtil.class);
    public static final String TAG_VALUE = "value";
    static final String TAG_ISDEFAULT = "isdefault";
    static final String TAG_ISDEFAULT_VALUE = "false";

    public static String getTagValueAsAdmin(String tagPath, SlingScriptHelper sling) {
        String tagValue = "";
        if (StringUtils.isEmpty((CharSequence)tagPath) || sling == null) {
            return tagValue;
        }
        ContentAccess contentAccess = (ContentAccess)sling.getService(ContentAccess.class);
        if (contentAccess != null) {
            try (ResourceResolver adminResourceResolver = contentAccess.getAdminResourceResolver();){
                TagManager _adminTagManager = (TagManager)adminResourceResolver.adaptTo(TagManager.class);
                Tag jcrTag = TagUtil.getTag(tagPath, adminResourceResolver, _adminTagManager);
                if (jcrTag != null) {
                    tagValue = jcrTag.getName();
                    Resource jcrTagResource = (Resource)jcrTag.adaptTo(Resource.class);
                    if (jcrTagResource != null) {
                        ValueMap tagVM = jcrTagResource.getValueMap();
                        if (tagVM != null && tagVM.containsKey((Object)TAG_VALUE)) {
                            tagValue = (String)tagVM.get(TAG_VALUE, (Object)jcrTag.getName());
                        }
                    } else {
                        LOGGER.error("getTagValueAsAdmin: could not convert tag to Resource, jcrTag={}", (Object)jcrTag);
                    }
                } else {
                    LOGGER.error("getTagValueAsAdmin: Could not find tag path: {}", (Object)tagPath);
                }
            }
            catch (Exception ex) {
                LOGGER.error("getTagValueAsAdmin: {}", (Throwable)ex);
            }
        } else {
            LOGGER.error("getTagValueAsAdmin: could not get ContentAccess service.");
        }
        return tagValue;
    }

    public static LinkedHashMap<String, Map> getTagsAsAdmin(SlingScriptHelper sling, String[] tagPaths, Locale locale) {
        return TagUtil.getTagsAsAdmin(sling, tagPaths, locale, new String[0], false);
    }

    public static LinkedHashMap<String, Map> getTagsAsAdmin(SlingScriptHelper sling, String[] tagPaths, Locale locale, String[] attributesToRead, boolean getTagChildren) {
        LinkedHashMap<String, Map> tags = new LinkedHashMap<String, Map>();
        if (sling == null || tagPaths == null || tagPaths.length == 0) {
            return tags;
        }
        ContentAccess contentAccess = (ContentAccess)sling.getService(ContentAccess.class);
        if (contentAccess != null) {
            try (ResourceResolver adminResourceResolver = contentAccess.getAdminResourceResolver();){
                Tag tag;
                TagManager tagManager = (TagManager)adminResourceResolver.adaptTo(TagManager.class);
                String[] tagPathsToLoad = tagPaths;
                if (getTagChildren) {
                    ArrayList<String> childList = new ArrayList<String>();
                    String[] stringArray = tagPathsToLoad;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        Resource tagRs;
                        String path = stringArray[i];
                        tag = TagUtil.getTag(path, adminResourceResolver, tagManager);
                        if (tag == null || !(tagRs = (Resource)tag.adaptTo(Resource.class)).hasChildren()) continue;
                        for (Resource child : tagRs.getChildren()) {
                            childList.add(child.getPath());
                        }
                    }
                    tagPathsToLoad = childList.toArray(new String[0]);
                }
                for (String path : tagPathsToLoad) {
                    HashMap<String, String> tagValues = new HashMap<String, String>();
                    tag = TagUtil.getTag(path, adminResourceResolver, tagManager);
                    if (tag == null) continue;
                    tagValues.put("title", tag.getTitle());
                    tagValues.put("description", tag.getDescription());
                    tagValues.put("path", tag.getPath());
                    Resource tagResource = (Resource)tag.adaptTo(Resource.class);
                    if (tagResource != null) {
                        String tagValue = tag.getName();
                        ValueMap tagVM = tagResource.getValueMap();
                        if (tagVM != null) {
                            if (tagVM.containsKey((Object)TAG_VALUE)) {
                                tagValue = (String)tagVM.get(TAG_VALUE, (Object)tag.getName());
                            }
                            if (tagVM.containsKey((Object)TAG_ISDEFAULT)) {
                                tagValue = (String)tagVM.get(TAG_ISDEFAULT, (Object)TAG_ISDEFAULT_VALUE);
                            }
                            if (locale != null) {
                                String titleLocal = "jcr:title".concat(".").concat(Text.escapeIllegalJcrChars((String)locale.toString().toLowerCase()));
                                if (tagVM.containsKey((Object)titleLocal)) {
                                    tagValues.put("title", (String)tagVM.get(titleLocal, (Object)tag.getName()));
                                }
                                tagValues.put("tagid", tag.getLocalTagID());
                                String valueLocal = TAG_VALUE.concat(".").concat(Text.escapeIllegalJcrChars((String)locale.toString().toLowerCase()));
                                if (tagVM.containsKey((Object)valueLocal)) {
                                    tagValue = (String)tagVM.get(valueLocal, (Object)tag.getName());
                                }
                            }
                            if (attributesToRead != null) {
                                for (String attribute : attributesToRead) {
                                    if (!tagVM.containsKey((Object)attribute)) continue;
                                    tagValues.put(attribute, (String)tagVM.get(attribute, null));
                                }
                            }
                        }
                        tagValues.put(TAG_VALUE, tagValue);
                    } else {
                        LOGGER.error("getTagsAsAdmin: could not get convert tag to Resource, tag={}", (Object)tag);
                    }
                    tags.put(tag.getTagID(), tagValues);
                }
            }
            catch (Exception ex) {
                LOGGER.error("getTagsAsAdmin: {}", (Throwable)ex);
            }
        } else {
            LOGGER.error("getTagsAsAdmin: could not get ContentAccess service.");
        }
        return tags;
    }

    public static String getTagsAsValuesAsAdmin(SlingScriptHelper sling, String separator, String[] tagPaths) {
        if (tagPaths == null || tagPaths.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String path : tagPaths) {
            String tagValue = TagUtil.getTagValueAsAdmin(path, sling);
            builder.append(tagValue);
            builder.append(separator);
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String getTagsAsValues(TagManager tagManager, ResourceResolver resourceResolver, String separator, String[] tagPaths) {
        if (tagPaths == null || tagPaths.length == 0) {
            return null;
        }
        boolean idx = false;
        StringBuilder builder = new StringBuilder();
        for (String path : tagPaths) {
            Tag jcrTag = tagManager.resolve(path);
            if (jcrTag == null) continue;
            String value = jcrTag.getName();
            Resource jcrTagResource = (Resource)jcrTag.adaptTo(Resource.class);
            if (jcrTagResource != null) {
                ValueMap tagVM = jcrTagResource.getValueMap();
                if (tagVM != null && tagVM.containsKey((Object)TAG_VALUE)) {
                    value = (String)tagVM.get(TAG_VALUE, (Object)jcrTag.getName());
                }
                builder.append(value);
                builder.append(separator);
                continue;
            }
            LOGGER.error("getTagsAsValues: could not convert tag to Resource, jcrTag={}", (Object)jcrTag);
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String[] getTagsValues(TagManager tagManager, ResourceResolver resourceResolver, String separator, String[] tagPaths) {
        if (tagPaths == null || tagPaths.length == 0) {
            return null;
        }
        boolean idx = false;
        ArrayList<String> tagValues = new ArrayList<String>();
        for (String path : tagPaths) {
            Tag jcrTag = tagManager.resolve(path);
            if (jcrTag == null) continue;
            String value = jcrTag.getName();
            Resource jcrTagResource = (Resource)jcrTag.adaptTo(Resource.class);
            if (jcrTagResource != null) {
                ValueMap tagVM = jcrTagResource.getValueMap();
                if (tagVM != null && tagVM.containsKey((Object)TAG_VALUE)) {
                    value = (String)tagVM.get(TAG_VALUE, (Object)jcrTag.getName());
                }
                tagValues.add(value);
                continue;
            }
            LOGGER.error("getTagsAsValues: could not convert tag to Resource, jcrTag={}", (Object)jcrTag);
        }
        return tagValues.toArray(new String[tagValues.size()]);
    }

    public static Tag getTag(String path, ResourceResolver resourceResolver, TagManager tagManager) {
        Resource rs;
        boolean possibleTagId = path.contains(String.valueOf(':'));
        String tagPath = path;
        if (possibleTagId) {
            Tag tag = tagManager.resolve(path);
            if (tag != null) {
                return tag;
            }
            tagPath = TagUtil.getPathFromTagId(path, "/content/cq:tags");
        }
        if (StringUtils.isNotEmpty((CharSequence)tagPath) && (rs = resourceResolver.resolve(tagPath)) != null) {
            return (Tag)rs.adaptTo(Tag.class);
        }
        return null;
    }

    public static String getPathFromTagId(String tagID, String tagsRoot) {
        String localID;
        String namespace;
        int colonPos = tagID.indexOf(58);
        if (colonPos > 0) {
            namespace = tagID.substring(0, colonPos);
            localID = tagID.substring(colonPos + 1);
        } else if (colonPos == 0) {
            namespace = "default";
            localID = tagID.substring(1);
        } else {
            namespace = "default";
            localID = tagID;
        }
        if (localID.endsWith("/")) {
            localID = localID.substring(0, localID.length() - 1);
        } else if (localID.length() == 0) {
            return tagsRoot + "/" + namespace;
        }
        return tagsRoot + "/" + namespace + "/" + localID;
    }

    public static Tag[] getPageTags(Page page) {
        return TagUtil.getPageTags(page, new Tag[0]);
    }

    public static Tag[] getPageTags(Page page, Tag[] defaultTags) {
        if (page == null) {
            return defaultTags;
        }
        try {
            return page.getTags();
        }
        catch (Exception ex) {
            LOGGER.error("could not read page tags {}", (Object)page);
            return new Tag[0];
        }
    }
}

