/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models;

import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import design.aem.components.ComponentProperties;
import design.aem.models.GenericComponent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL, adapters={GenericComponent.class, ComponentExporter.class})
@Exporter(name="jackson", extensions={"json"})
public class GenericModel
implements GenericComponent {
    @ScriptVariable
    protected Resource resource;
    @ScriptVariable
    protected PageManager pageManager;
    @ScriptVariable
    protected Page currentPage;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected Style currentStyle;
    @ScriptVariable
    protected Page resourcePage;
    @ScriptVariable
    protected ValueMap pageProperties;
    @ScriptVariable
    protected ValueMap properties;
    @ScriptVariable
    protected Designer designer;
    @ScriptVariable
    protected Design currentDesign;
    @ScriptVariable
    protected Component component;
    @ScriptVariable
    protected ValueMap inheritedPageProperties;
    @SlingObject
    protected ResourceResolver resourceResolver;
    @Self
    protected SlingHttpServletRequest slingHttpServletRequest;
    @SlingObject
    protected SlingHttpServletResponse slingHttpServletResponse;
    @SlingObject
    protected SlingScriptHelper slingScriptHelper;
    @ScriptVariable
    protected ComponentContext componentContext;
    @ScriptVariable
    protected Design resourceDesign;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected ComponentProperties componentProperties;

    @Override
    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    @Nonnull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    public final PageManager getPageManager() {
        return this.pageManager;
    }

    public final Page getCurrentPage() {
        return this.currentPage;
    }

    public final Page getResourcePage() {
        return this.resourcePage;
    }

    public final ValueMap getPageProperties() {
        return this.pageProperties;
    }

    public final ValueMap getProperties() {
        return this.properties;
    }

    public final Designer getDesigner() {
        return this.designer;
    }

    public final Design getCurrentDesign() {
        return this.currentDesign;
    }

    public final Style getCurrentStyle() {
        return this.currentStyle;
    }

    public final Component getComponent() {
        return this.component;
    }

    public final ValueMap getInheritedPageProperties() {
        return this.inheritedPageProperties;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public final SlingHttpServletRequest getRequest() {
        return this.slingHttpServletRequest;
    }

    public final SlingHttpServletResponse getResponse() {
        return this.slingHttpServletResponse;
    }

    public final SlingScriptHelper getSlingScriptHelper() {
        return this.slingScriptHelper;
    }

    public final ComponentContext getComponentContext() {
        return this.componentContext;
    }

    public final EditContext getEditContext() {
        return this.componentContext.getEditContext();
    }

    public final Design getResourceDesign() {
        return this.resourceDesign;
    }

    public final Node getCurrentNode() {
        return (Node)this.resource.adaptTo(Node.class);
    }

    public final I18n getI18n() {
        return new I18n((HttpServletRequest)this.getRequest());
    }

    public Map<String, Object> getPageContextMap() {
        HashMap<String, Object> pageContextMap = new HashMap<String, Object>();
        pageContextMap.put("slingRequest", this.getRequest());
        pageContextMap.put("resourceResolver", this.getResourceResolver());
        pageContextMap.put("sling", this.getSlingScriptHelper());
        pageContextMap.put("componentContext", this.getComponentContext());
        pageContextMap.put("resource", this.getResource());
        pageContextMap.put("currentNode", this.getCurrentNode());
        pageContextMap.put("properties", this.getProperties());
        pageContextMap.put("currentStyle", this.getCurrentStyle());
        pageContextMap.put("currentPage", this.getCurrentPage());
        pageContextMap.put("resourcePage", this.getResourcePage());
        pageContextMap.put("resourceDesign", this.getResourceDesign());
        pageContextMap.put("object", this);
        pageContextMap.put("objecttype", "slingmodel");
        return pageContextMap;
    }

    @PostConstruct
    protected void initModel() {
        throw new UnsupportedOperationException();
    }
}

