/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.common;

import com.adobe.cq.sightly.WCMUsePojo;
import com.google.gson.Gson;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.ComponentsUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.sling.api.request.RequestProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timing
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Timing.class);
    private static final String TIMER_END = "TIMER_END";
    protected ComponentProperties componentProperties = null;

    private static String basename(String path) {
        String result = path;
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            result = result.substring(pos + 1);
        }
        return result;
    }

    private static boolean accept(String line) {
        boolean result = line.contains(TIMER_END);
        result &= !line.contains(",resolveServlet(");
        result &= !line.contains("ResourceResolution");
        return result &= !line.contains("ServletResolution");
    }

    public static byte[] compress(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return new byte[0];
        }
        String charsetName = "UTF-8";
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(str.getBytes("UTF-8"));
        gzip.close();
        return obj.toByteArray();
    }

    public static String decompress(byte[] bytes) throws IOException {
        String line;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(bytes));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8));
        StringBuilder output = new StringBuilder();
        while ((line = bf.readLine()) != null) {
            output.append(line);
        }
        return output.toString();
    }

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        this.setComponentFields(new Object[][]{{"variant", "default"}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE});
        RequestProgressTracker t = this.getRequest().getRequestProgressTracker();
        ArrayList<ChartBar> chartData = new ArrayList<ChartBar>();
        int maxTime = 0;
        Iterator messages = t.getMessages();
        if (messages != null) {
            while (messages.hasNext()) {
                String line = (String)messages.next();
                if (!Timing.accept(line)) continue;
                ChartBar b = new ChartBar(line);
                chartData.add(b);
                maxTime = b.end;
            }
        }
        long millis = maxTime;
        long hours = TimeUnit.MICROSECONDS.toHours(millis);
        long minutes = TimeUnit.MICROSECONDS.toMinutes(millis -= TimeUnit.HOURS.toMicros(hours));
        long seconds = TimeUnit.MICROSECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMicros(minutes));
        String title = Timing.basename(this.getRequest().getPathInfo()) + " (" + String.format("%02d:%02d:%02d.%d", hours, minutes, seconds, millis -= TimeUnit.SECONDS.toMicros(seconds)) + ")";
        Collections.sort(chartData, new Comparator<ChartBar>(){

            @Override
            public int compare(ChartBar a, ChartBar b) {
                if (a.start > b.start) {
                    return 1;
                }
                if (a.start < b.start) {
                    return -1;
                }
                return 0;
            }
        });
        String url = "http://aem.design/component-timing/#data=";
        byte[] encoded = new byte[]{};
        try {
            HashMap<String, Object> dataObject = new HashMap<String, Object>();
            dataObject.put("title", title);
            ArrayList data = new ArrayList();
            ArrayList<Object> dataInfo = new ArrayList<Object>();
            dataInfo.add("name");
            HashMap<String, String> roleTooltip = new HashMap<String, String>();
            roleTooltip.put("role", "tooltip");
            dataInfo.add(roleTooltip);
            dataInfo.add("start");
            dataInfo.add("elapsed");
            data.add(dataInfo);
            for (ChartBar d : chartData) {
                ArrayList<Object> bar = new ArrayList<Object>();
                bar.add(d.name);
                bar.add(d.fullname);
                bar.add(d.start);
                bar.add(d.elapsed);
                data.add(bar);
            }
            dataObject.put("data", data);
            Gson gson = new Gson();
            String jsonString = gson.toJson(dataObject);
            byte[] compressed = Timing.compress(jsonString);
            encoded = Base64.getEncoder().encode(compressed);
            this.componentProperties.put("url", url);
            this.componentProperties.put("encodedData", new String(encoded));
            this.componentProperties.put("jsonString", jsonString);
        }
        catch (Exception ex) {
            LOGGER.error("ready {}", (Throwable)ex);
        }
    }

    public static interface Getter {
        public String get(ChartBar var1);
    }

    static class ChartBar {
        private static final String ELLIPSIS = "...";
        private static final int MAX_LABEL_LENGTH = 25;
        String input;
        String name;
        String fullname;
        int start;
        int end;
        int elapsed;

        ChartBar(String line) {
            try {
                this.input = line.trim();
                this.end = Integer.valueOf(this.scan(' '));
                this.scan('{');
                this.elapsed = Integer.valueOf(this.scan(','));
                this.start = this.end - this.elapsed;
                this.fullname = ChartBar.cutBeforeLast(this.scan('}'), '#');
                this.name = ChartBar.shortForm(this.fullname);
            }
            catch (NumberFormatException ex) {
                this.name = this.fullname = ex.toString();
            }
        }

        private static String cutBeforeLast(String str, char separator) {
            int pos = str.lastIndexOf(separator);
            if (pos > 0) {
                str = str.substring(0, pos);
            }
            return str;
        }

        private static String shortForm(String str) {
            String result = Timing.basename(str);
            if (result.length() > 25) {
                result = result.substring(0, 25 - ELLIPSIS.length()) + ELLIPSIS;
            }
            return result;
        }

        private String scan(char separator) {
            char c;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.input.length() && (c = this.input.charAt(i)) != separator; ++i) {
                sb.append(c);
            }
            this.input = this.input.substring(sb.length() + 1);
            return sb.toString().trim();
        }
    }
}

