/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.content;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.i18n.I18n;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.ImagesUtil;
import design.aem.utils.components.ResolverUtil;
import java.text.MessageFormat;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Download
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Download.class);
    protected ComponentProperties componentProperties = null;
    private static final String DEFAULT_I18N_CATEGORY = "download";
    private static final String DEFAULT_I18N_LABEL = "downloadlabel";
    private static final String DEFAULT_TITLE_TAG_TYPE = "h4";
    private static final String EMPTY_FILE = "empty file";
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_THUMBNAIL = "thumbnail";

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"thumbnailType", "icon"}, {"label", I18nUtil.getDefaultLabelIfEmpty("", DEFAULT_I18N_CATEGORY, DEFAULT_I18N_LABEL, DEFAULT_I18N_CATEGORY, i18n, new String[0])}, {"thumbnailWidth", "", "thumbnailWidth"}, {"thumbnailHeight", "", "thumbnailHeight"}, {FIELD_TITLE, ""}, {"titleType", DEFAULT_TITLE_TAG_TYPE}, {FIELD_DESCRIPTION, ""}, {"fileReference", ""}, {FIELD_THUMBNAIL, "/etc.clientlibs/settings/wcm/designs/aemdesign/clientlibs-theme/resources/blank.png"}});
        this.setAnalyticsFields(new Object[][]{{"badgeAnalyticsLabel", "${(fileReference ? fileReference + '|' : '') + value }"}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS, this.analyticsFields});
        String variant = (String)this.componentProperties.get("variant", "default");
        com.day.cq.wcm.foundation.Download dld = new com.day.cq.wcm.foundation.Download(this.getResource());
        this.componentProperties.put("hasContent", dld.hasContent());
        if (dld.hasContent()) {
            String mimeType = this.getDownloadMimeType(this.getResourceResolver(), dld);
            String mimeTypeLabel = i18n.get(mimeType, DEFAULT_I18N_CATEGORY);
            Resource assetRes = dld.getResourceResolver().resolve(dld.getHref());
            if (!ResourceUtil.isNonExistingResource((Resource)assetRes)) {
                Asset asset = (Asset)assetRes.adaptTo(Asset.class);
                Node assetN = (Node)asset.adaptTo(Node.class);
                String href = ResolverUtil.mappedUrl(this.getResourceResolver(), dld.getHref());
                String assetDescription = asset.getMetadataValue("dc:description");
                String assetTitle = asset.getMetadataValue("dc:title");
                String assetTags = ImagesUtil.getMetadataStringForKey(assetN, "cq:tags", "");
                String licenseInfo = ImagesUtil.getAssetCopyrightInfo(asset, i18n.get("licenseinfo", DEFAULT_I18N_CATEGORY));
                String title = (String)this.componentProperties.get(FIELD_TITLE, "");
                if (StringUtils.isNotEmpty((CharSequence)licenseInfo)) {
                    this.componentProperties.put("isLicensed", true);
                    if (StringUtils.isNotEmpty((CharSequence)assetTitle)) {
                        this.componentProperties.put("hasAssetTitle", true);
                        title = assetTitle;
                    } else {
                        this.componentProperties.put("hasAssetTitle", false);
                        title = assetRes.getName();
                    }
                } else {
                    this.componentProperties.put("isLicensed", false);
                    if (StringUtils.isEmpty((CharSequence)title) && StringUtils.isNotEmpty((CharSequence)assetTitle)) {
                        this.componentProperties.put("hasAssetTitleOveride", false);
                        title = assetTitle;
                    } else {
                        this.componentProperties.put("hasAssetTitleOveride", true);
                    }
                }
                this.componentProperties.put(FIELD_TITLE, title);
                String description = (String)this.componentProperties.get(FIELD_DESCRIPTION, "");
                if (StringUtils.isNotEmpty((CharSequence)licenseInfo) || StringUtils.isEmpty((CharSequence)description) && StringUtils.isNotEmpty((CharSequence)assetDescription)) {
                    this.componentProperties.put(FIELD_DESCRIPTION, assetDescription);
                }
                this.componentProperties.put("licenseInfo", licenseInfo);
                this.componentProperties.put("mimeTypeLabel", mimeTypeLabel);
                this.componentProperties.put("assetTitle", assetTitle);
                this.componentProperties.put("assetDescription", assetDescription);
                this.componentProperties.put("href", href);
                String thumbnailType = (String)this.componentProperties.get("thumbnailType", "");
                String assetAsThumbnail = assetRes.getPath();
                String thumbnailImagePath = ImagesUtil.getResourceImagePath(this.getResource(), FIELD_THUMBNAIL);
                if (StringUtils.isNotEmpty((CharSequence)thumbnailImagePath)) {
                    this.componentProperties.put(FIELD_THUMBNAIL, thumbnailImagePath);
                } else {
                    this.componentProperties.put(FIELD_THUMBNAIL, assetAsThumbnail);
                }
                if (thumbnailType.equals("dam")) {
                    Rendition assetRendition = ImagesUtil.getThumbnail(asset, 319);
                    if (assetRendition == null) {
                        this.componentProperties.put(FIELD_THUMBNAIL, "/content/dam/aemdesign/common/download.png");
                    } else {
                        this.componentProperties.put(FIELD_THUMBNAIL, assetRendition.getPath());
                    }
                } else if (thumbnailType.equals("customdam")) {
                    Resource thumbnailImage = this.getResourceResolver().resolve(thumbnailImagePath);
                    if (ResourceUtil.isNonExistingResource((Resource)thumbnailImage)) {
                        thumbnailImagePath = "/content/dam/aemdesign/common/download.png";
                    } else {
                        Rendition assetRendition = ImagesUtil.getThumbnail((Asset)thumbnailImage.adaptTo(Asset.class), 319);
                        thumbnailImagePath = assetRendition.getPath();
                    }
                    this.componentProperties.put(FIELD_THUMBNAIL, thumbnailImagePath);
                } else if (thumbnailType.equals("custom")) {
                    String thumbnailImage = ImagesUtil.getResourceImageCustomHref(this.getResource(), FIELD_THUMBNAIL);
                    if (StringUtils.isEmpty((CharSequence)thumbnailImage)) {
                        this.componentProperties.put(FIELD_THUMBNAIL, "/content/dam/aemdesign/common/download.png");
                    } else {
                        this.componentProperties.put(FIELD_THUMBNAIL, thumbnailImage);
                    }
                } else if (thumbnailType.equals("icon") || StringUtils.isEmpty((CharSequence)thumbnailType)) {
                    this.componentProperties.put("iconType", dld.getIconType());
                }
                this.componentProperties.attr.add("href", href);
                this.componentProperties.attr.add("data-tags", assetTags);
                this.componentProperties.put("componentAttributes", ComponentsUtil.buildAttributesString(this.componentProperties.attr.getData(), null));
                this.componentProperties.put("info", MessageFormat.format("({0}, {1})", this.getFormattedDownloadSize(dld), mimeTypeLabel));
            } else {
                variant = "empty";
            }
        } else {
            variant = "empty";
        }
        if (StringUtils.isNotEmpty((CharSequence)variant)) {
            this.componentProperties.put("variant", variant);
            this.componentProperties.put("variantTemplate", MessageFormat.format("variant.{0}.html", variant));
        }
    }

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    private String getFormattedDownloadSize(com.day.cq.wcm.foundation.Download dld) {
        String size = "";
        try {
            if (dld.getData() != null) {
                size = this.getFileSize(dld.getData().getLength());
            }
        }
        catch (Exception ex) {
            LOGGER.error("getFormattedDownloadSize {}", (Throwable)ex);
        }
        return size;
    }

    private String getDownloadMimeType(ResourceResolver resolver, com.day.cq.wcm.foundation.Download download) {
        String mimeTypeReturn = "";
        try {
            Asset asset;
            String filePath = download.getFileReference();
            Resource resource = resolver.resolve(filePath);
            if (!ResourceUtil.isNonExistingResource((Resource)resource) && (asset = (Asset)resource.adaptTo(Asset.class)) != null) {
                String mimeType = asset.getMimeType();
                mimeTypeReturn = mimeType.split("/")[1].toUpperCase();
            }
        }
        catch (Exception ex) {
            LOGGER.error("getDownloadMimeType: {}", (Throwable)ex);
        }
        return mimeTypeReturn;
    }

    private String getFileSize(Long fileSize) {
        if (fileSize == null) {
            return EMPTY_FILE;
        }
        String fileSizeReturn = EMPTY_FILE;
        try {
            String[] measures = new String[]{"bytes", "kB", "MB", "GB"};
            Double measurementIndex = Math.floor(Math.log10(fileSize.longValue()) / 3.0);
            Double decSize = (double)fileSize.longValue() / Math.pow(1024.0, measurementIndex);
            fileSizeReturn = String.format("%.0f %S", decSize, measures[measurementIndex.intValue()]);
        }
        catch (Exception ex) {
            LOGGER.error("getFileSize: {}", (Throwable)ex);
        }
        return fileSizeReturn;
    }
}

