/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.content;

import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.security.user.UserPropertiesService;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.SecurityUtil;
import java.text.MessageFormat;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.UserManager;

public class PageAuthor
extends ModelProxy {
    protected ComponentProperties componentProperties = null;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() throws Exception {
        UserPropertiesService userPropertiesService = (UserPropertiesService)this.getSlingScriptHelper().getService(UserPropertiesService.class);
        String pageAuthorFullName = "";
        String pageAuthorEmail = "";
        Node currentNode = (Node)this.getResource().adaptTo(Node.class);
        if (currentNode != null && userPropertiesService != null) {
            Session session = currentNode.getSession();
            UserPropertiesManager userPropertiesManager = userPropertiesService.createUserPropertiesManager(session, this.getResourceResolver());
            UserManager userManager = (UserManager)this.getResourceResolver().adaptTo(UserManager.class);
            String pageAuthorUser = this.getResourcePage().getLastModifiedBy();
            if (StringUtils.isNotBlank((CharSequence)pageAuthorUser)) {
                pageAuthorFullName = SecurityUtil.getUserFullName(userManager, userPropertiesManager, pageAuthorUser, "");
                pageAuthorEmail = SecurityUtil.getUserEmail(userManager, userPropertiesManager, pageAuthorUser, "");
                pageAuthorEmail = StringUtils.isNotBlank((CharSequence)pageAuthorEmail) ? MessageFormat.format("mailto:{0}", pageAuthorEmail) : "#";
            } else {
                pageAuthorFullName = session.getUserID();
            }
        }
        this.setComponentFields(new Object[][]{{"author", pageAuthorFullName}, {"authorUrl", pageAuthorEmail}, {"variant", "default"}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY});
    }
}

